% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climatogram.R
\name{climatogram_normal}
\alias{climatogram_normal}
\title{Walter & Lieth climatic diagram from normal climatology values}
\usage{
climatogram_normal(
  station,
  labels = "en",
  verbose = FALSE,
  ggplot2 = TRUE,
  ...
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}})}

\item{labels}{Character string as month labels for the X axis: "en"
(english), "es" (spanish), "fr" (french), etc.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{ggplot2}{\code{TRUE/FALSE}. On \code{TRUE} the function uses
\code{\link[=ggclimat_walter_lieth]{ggclimat_walter_lieth()}}, if \code{FALSE} uses \code{\link[climatol:diagwl]{climatol::diagwl()}}.}

\item{...}{Further arguments to
\code{\link[climatol:diagwl]{climatol::diagwl()}} or \code{\link[=ggclimat_walter_lieth]{ggclimat_walter_lieth()}}, depending on the
value of \code{ggplot2}}
}
\value{
A plot.
}
\description{
Plot of a Walter & Lieth climatic diagram from normal climatology data for
a station. This climatogram are great for showing a summary of climate
conditions for a place over a time period (1981-2010).
}
\note{
The code is based on code from the CRAN package \CRANpkg{climatol}
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
climatogram_normal("9434")
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Walter, H. K., Harnickell, E., Lieth, F. H. H., & Rehder, H. (1967).
\emph{Klimadiagramm-weltatlas}. Jena: Fischer, 1967.
\item Guijarro J. A. (2023).
\emph{climatol: Climate Tools (Series Homogenization and Derived Products)}. R
package version 4.0.0, \url{https://climatol.eu}.
}
}
\seealso{
Other aemet_plots: 
\code{\link{climatestripes_station}()},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()},
\code{\link{ggstripes}()},
\code{\link{ggwindrose}()},
\code{\link{windrose_days}()},
\code{\link{windrose_period}()}

Other climatogram: 
\code{\link{climaemet_9434_climatogram}},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()}
}
\concept{aemet_plots}
\concept{climatogram}
