% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wl.R
\encoding{UTF-8}
\name{plot_wl}
\alias{plot_wl}
\title{plot_wl}
\usage{
plot_wl(data, geo_id, ...)
}
\arguments{
\item{data}{List. Containing climate, elevation and latitude
data sets. Structured by \code{ce_extract()}.}

\item{geo_id}{Character. Corresponding to a specific feature contained in the
\code{"location"} argument (specifically in the \code{"location_g"} column).}

\item{\dots}{Arguments to control styling in
\code{ggclimat_walter_lieth()}.}
}
\value{
Returns a base R family of plot. This function uses the \pkg{climaemet}
package to create the Walter and Lieth (1960) climatic diagram.
}
\description{
Creates a graph using the climate and elevation data which has
been extracted for a given \code{location}. It accepts the data formatted
from the \code{ce_extract} function.
}
\examples{
# Step 1. Import the Italian Biome polygon data
# Step 2. Run the download function
# Step 3. Run the extract function
#* See ce_download & ce_extract documentation

# Steps 1, 2 & 3 can be skipped by loading the extracted data (it_data)
data("it_data", package = "climenv")

# Step 4. Visualise the climatic envelope using a Walter-Lieth diagram

plot_wl(data = it_data, geo_id = "NEM")

}
\references{
{ Pizarro, M, Hernangómez, D. &
Fernández-Avilés G. (2023). climaemet: Climate AEMET Tools.
Comprehensive R Archive Network. \doi{10.5281/zenodo.5205573}

Walter, H.B., & Lieth, H. (1960). Klimadiagramm-Weltatlas. VEB Gustav
Fischer Verlag, Jena.

}
}
\seealso{
Download climate data: \code{\link[=ce_download]{ce_download()}}
}
\author{
James L. Tsakalos and Martin R. Smith
}
