% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotbest.R
\name{plotbest}
\alias{plotbest}
\title{Visualise the best climate window}
\usage{
plotbest(Dataset, BestModel, BestModelData)
}
\arguments{
\item{Dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{BestModel}{A model object. The strongest climate window model. Output
from \code{\link{singlewin}} or \code{\link{climatewin}}.}

\item{BestModelData}{A dataframe with the data used to
fit the strongest climate window model. Output from \code{\link{singlewin}}
or \code{\link{climatewin}}.}
}
\value{
Returns a scatterplot with a fitted line to show the fit of the best
 model through the data.
}
\description{
Create a scatterplot showing the fit of the best climate window model through
the biological data.
}
\examples{
# Visualise the best climate window from the datasets Mass and MassClimate

data(MassOutput)
data(Mass)
data(MassClimate)

single <- singlewin(Xvar = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                   baseline = lm(Mass$Mass ~ 1),furthest = 72, closest = 15,
                   STAT = "mean", FUNC = "L",
                   FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                   CMISSING = FALSE, CINTERVAL = "D")

plotbest(Dataset = MassOutput, BestModel = single[[1]],
        BestModelData = single[[2]])
}
\author{
Liam D. Bailey and Martijn van de Pol
}

