% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotweights.R
\name{plotweights}
\alias{plotweights}
\title{Plot distribution of model weights}
\usage{
plotweights(Dataset, CW1 = 0.95, CW2 = 0.5, CW3 = 0.25)
}
\arguments{
\item{Dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{CW1,CW2,CW3}{Cumulative weight levels used to visualise model weight
distribution. Cumulative weights represent the chance that the best model is
contained within a set. For example, there is a 95 percent chance that the best
climate window model is contained within the cumulative weight level of
0.95. Parameter values must <= 1.}
}
\value{
Returns a colour plot showing the distribution of cumulative model
 weights. Colour levels determined by parameters CW1,CW2 and CW3.
}
\description{
Create a colour plot showing the distribution of cumulative model weights for
all fitted climate windows.
}
\examples{
# Plot distribution of model weights for Mass dataset

data(MassOutput)

plotweights(Dataset = MassOutput, CW1 = 0.95, CW2 = 0.75, CW3 = 0.25)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

