% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataManipulation-transformData.R
\name{transformData}
\alias{transformData}
\title{Transform data.}
\usage{
transformData(data, transformations, verbose = FALSE, labelVars = NULL)
}
\arguments{
\item{data}{Data.frame with input data to transform.}

\item{transformations}{Transformations (or list of those) as a list with:
\itemize{
\item{'type': }{String with type of transformation.
Currently, only: 'pivot_wider' is available}
\item{extra parameters for the transformation, for:
\itemize{
\item{'pivot_wider': }{
\itemize{
\item{'varsID': }{Character vector with variable(s) of \code{data}
defining unique records in the wide format.
Corresponds to the \code{idvar} parameter of the \code{reshape} function.}
\item{'varPivot': }{String with unique variable of \code{data}
containing elements to pivot in different columns in the wide format
(used for column names).
Corresponds to the \code{timevar} parameter of the \code{reshape} function.}
\item{'varsValue': }{Character vector with variable(s) of \code{data}
used to fill the columns in the wide format.
Corresponds to the \code{v.names} parameter of the \code{reshape} function.}
}
}
}
}
}}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}

\item{labelVars}{Named character vector containing variable labels.}
}
\value{
A data.frame in wide format.
}
\description{
Transform data from long to wide format.
This function converts formats with the \code{stats::reshape} function.
}
\author{
Laure Cougnaud
}
