% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-scatterplotClinData.R
\name{scatterplotClinData}
\alias{scatterplotClinData}
\title{Scatterplot of variables of interest for clinical data visualization.}
\usage{
scatterplotClinData(
  data,
  xVar,
  yVar,
  xLab = getLabelVar(xVar, labelVars = labelVars),
  yLab = getLabelVar(yVar, labelVars = labelVars),
  aesPointVar = list(),
  pointPars = list(),
  aesLineVar = list(),
  linePars = list(),
  lineInclude = length(aesLineVar) > 0,
  aesSmoothVar = list(),
  smoothPars = list(),
  smoothInclude = length(c(aesSmoothVar, smoothPars)) > 0,
  aesLab,
  xTrans = "identity",
  yTrans = "identity",
  xPars = list(),
  yPars = list(),
  xLabVars = NULL,
  yLim = NULL,
  xLim = NULL,
  yLimExpandData = TRUE,
  xLimExpandData = TRUE,
  titleExtra = NULL,
  title = paste(paste(yLab, "vs", xLab, titleExtra), collapse = "<br>"),
  caption = NULL,
  subtitle = NULL,
  facetPars = list(),
  facetType = c("wrap", "grid"),
  scalePars = list(),
  themePars = list(legend.position = "bottom"),
  refLinePars = NULL,
  labelVars = NULL,
  width = NULL,
  height = NULL,
  hoverVars,
  hoverLab,
  idVar = "USUBJID",
  idLab = getLabelVar(idVar, labelVars = labelVars),
  idHighlightBox = FALSE,
  pathVar = NULL,
  pathExpand = FALSE,
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  selectVars = NULL,
  selectLab = getLabelVar(selectVars, labelVars = labelVars),
  table = FALSE,
  tableVars,
  tableLab,
  tableButton = TRUE,
  tablePars = list(),
  verbose = FALSE
)
}
\arguments{
\item{data}{Data.frame with input data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{xLab}{String with label for \code{xVar}.}

\item{yLab}{String with label for \code{xVar}.}

\item{aesPointVar}{List with specification of aesthetic variable(s),
for the point, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_point}},
e.g. \code{list(color = "TRTP")}.\cr
Please note by default symbols with fill and color are used.
Color is used for the outside of the points, fill for the inside
and the hover. Usually, you might want to specify both
filling and coloring.}

\item{pointPars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_point}},
defaults to empty list.}

\item{aesLineVar}{List with specification of aesthetic variable(s),
for the line, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_line}},
e.g. \code{list(group = "USUBJID")}.}

\item{linePars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_line}},
defaults to empty list.}

\item{lineInclude}{Logical, if TRUE (by default if \code{aesLineVar} is specified)
include a scatterplot.}

\item{aesSmoothVar}{List with specification of aesthetic variable(s),
for the smoothing layer, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_smooth}} defaults to empty list.}

\item{smoothPars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_smooth}},
defaults to empty list. Note this parameter overwrites other parameters set by \code{aesSmoothVar}.}

\item{smoothInclude}{Logical, if TRUE (by default if one of \code{aesSmoothVar or smoothPars} is non-empty)}

\item{aesLab}{Named character vector with labels for each aesthetic variable.}

\item{xTrans, yTrans}{Transformation for the x/y- variables,
passed to the \code{trans} parameter of \code{\link[ggplot2]{scale_x_continuous}}/
\code{\link[ggplot2]{scale_y_continuous}}.}

\item{xPars, yPars}{List with extra parameters for x/y axis, passed to the
\code{\link[ggplot2]{scale_x_continuous}}/
\code{\link[ggplot2]{scale_y_continuous}} functions,
besides \code{trans} and \code{limits}.}

\item{xLabVars}{Character vector with variable(s) to be displayed 
as the labels of the ticks in the x-axis.\cr
By default, \code{xVar} is displayed.\cr
If specified, this overwrites any \code{labels} specified via \code{xPars}.\cr
In case the variable(s) contain different elements 
by \code{xVar} or between facets, they are combined
and displayed below each other.}

\item{xLim, yLim}{Numeric vector of length 2 with limits for the x/y axes.}

\item{xLimExpandData, yLimExpandData}{Logical (TRUE by default), should the
limits specified via \code{xLim}/\code{yLim} be 
expanded to include any data points outside of these
limits?
Please note that the same limits are set for all facets.}

\item{titleExtra}{String with extra title for the plot (appended after \code{title}).}

\item{title}{String with title for the plot.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{facetPars}{List with facetting parameters, passed to the facetting function.}

\item{facetType}{String with facetting type, either:
\itemize{
\item 'wrap': \code{\link[ggplot2]{facet_wrap}}
\item 'grid': \code{\link[ggplot2]{facet_grid}}
}}

\item{scalePars}{List with parameters to customize
scales. Each sublist should contains a set of parameters
passed to the \code{\link[ggplot2]{scale_discrete_manual}}
function.\cr
If palette(s) are not specified, default palettes are used
(see \link[clinUtils]{getColorPalette}, 
\link[clinUtils]{getShapePalette}, 
\link[clinUtils]{getLinetypePalette}
)}

\item{themePars}{List with general theme parameters 
(see \code{\link[ggplot2]{theme}}).}

\item{refLinePars}{(optional) Nested list, with parameters for each reference line(s).
Each sublist (a.k.a reference line) contains:
\itemize{
\item aesthetic value(s) or variable(s) for the lines
(in this case column names of \code{data}) for reference lines.
The line position is controlled by the aesthetics supported in
\code{\link[ggplot2]{geom_vline}}, \code{\link[ggplot2]{geom_hline}} 
and \code{\link[ggplot2]{geom_abline}}.
\item 'label': (optional) Logical specifying if the line
should be annotated (\code{FALSE} to not annotate the line)
or string with annotation label. By default, the value
of the position of the horizontal/vertical line or the equation
of the diagonal line is displayed.
}}

\item{labelVars}{Named character vector containing variable labels.}

\item{width}{Numeric, width of the plot in pixels,
700 by default.}

\item{height}{Numeric, height of the plot in pixels,
700 by default.}

\item{hoverVars}{Character vector with variables to be displayed in the hover,
by default \code{xVar}, \code{yVar} and any aesthetic variables.}

\item{hoverLab}{Named character vector with labels for \code{hoverVars}.}

\item{idVar}{String with variable containing subject ID.}

\item{idLab}{String with label for \code{idVar}.}

\item{idHighlightBox}{Logical, if TRUE (FALSE by default) a selectize box
is included to highlight selected element(s) of the ID variable (\code{idVar}).}

\item{pathVar}{String with variable of \code{data} containing
path to a subject-specific report. The report info should be unique 
for each element of \code{idVar}.
The report will be:
\itemize{
\item opened in a different window in the browser if the user clicks on the 
'p' (a.k.a 'profile') key when hovering on a point of the plot
\item opened in the browser via hyperlink in the table
}}

\item{pathExpand}{Logical, if FALSE (by default)
the path to subject-report is included in an hyperlink in the table,
otherwise a collapsed row is created.
This should be set to TRUE only if multiple paths 
are included for each row in \code{pathVar}
(e.g. in case of summary table).}

\item{id}{String with general id for the plot:
\itemize{
\item 'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}
\item 'button:[id]' is used as button ID if \code{table} is TRUE
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{selectVars}{(optional) Character vector with variable(s) from \code{data}
for which a selection box should be included. This enables to select the data
displayed in the plot (and associated table).}

\item{selectLab}{(Named) character vector with label for \code{selectVars}.}

\item{table}{Logical, if TRUE (FALSE by default)
returns also a \code{datatable} containing the plot data.
The plot and table are linked when included in a Rmarkdown document: 
when clicking on an plot element,
only the corresponding records are retained in the associated table;
when some records are selected in the table, they are highlighted in the 
associated table.}

\item{tableVars}{Character vector with variables to be included 
in the table.}

\item{tableLab}{Named character vector with labels
for each \code{tableVars}.}

\item{tableButton}{Logical, if TRUE (by default)
the table is included within an HTML button.}

\item{tablePars}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}
}
\value{
Either:
\itemize{
\item if a \code{table} is requested: a \code{clinDataReview} object, 
a.k.a a list with the 'plot' (\code{\link[plotly]{plotly}} object) and 'table'
(\code{\link[DT]{datatable}} object)
\item otherwise: a \code{\link[plotly]{plotly}} object
}
}
\description{
The parameters for this visualization
are based on \code{ggplot2} (aesthetic, scale, ...), parameter specification,
unlike the other visualizations of the package.
}
\examples{
library(clinUtils)

data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

dataLB <- dataADaMCDISCP01$ADLBC
dataDM <- dataADaMCDISCP01$ADSL
dataLB <- annotateData(dataLB, annotations = list(data = dataDM))
# subset of the data for the example
dataLB <- subset(dataLB, VISIT \%in\% c("SCREENING 1", "WEEK 2", "WEEK 8"))

## time profile

dataPlot <- subset(dataLB, PARAMCD == "ALT")

# with relative day
scatterplotClinData(
	data = dataPlot, 
	xVar = "ADY",
	yVar = "LBSTRESN",
	aesPointVar = list(color = "TRTP", fill = "TRTP"),
	aesLineVar = list(group = "USUBJID", color = "TRTP"),
	labelVars = labelVars
)

# with actual visit
dataPlot$AVISIT <- with(dataPlot, reorder(trimws(AVISIT), AVISITN))
scatterplotClinData(
	data = dataPlot, 
	xVar = "AVISIT",
	yVar = "LBSTRESN",
	aesPointVar = list(color = "TRTP", fill = "TRTP"),
	aesLineVar = list(group = "USUBJID", color = "TRTP"),
	labelVars = labelVars
)



\dontrun{

# add number of subjects below each visit
	
if (requireNamespace("inTextSummaryTable", quietly = TRUE)) {

# compute number of subjects by visit
summaryTable <- inTextSummaryTable::computeSummaryStatisticsTable(
	dataPlot,
	rowVar = "AVISIT",
	stats = "n"
)
# add it in the data
dataPlot <- merge(dataPlot, summaryTable[, c("AVISIT", "n")], all.x = TRUE)
dataPlot$n <- paste0("N=", dataPlot$n)

scatterplotClinData(
	data = dataPlot, 
	xVar = "AVISIT", xLabVars = c("AVISIT", "n"),
	yVar = "LBSTRESN",
	aesPointVar = list(color = "TRTP", fill = "TRTP"),
	aesLineVar = list(group = "USUBJID", color = "TRTP"),
	labelVars = labelVars
)

}

}

## pairwise comparison plot of two parameters of interest:

# format data long -> wide format (one column per lab param)
dataPlot <- subset(dataLB, PARAMCD \%in\% c("ALT", "AST"))
dataPlot <- stats::aggregate(
	LBSTRESN ~ USUBJID + VISIT + VISITNUM + PARAMCD, 
	data = dataPlot,
	FUN = mean
)
dataPlotWide <- stats::reshape(
	data = dataPlot,
	timevar = "PARAMCD", idvar = c("USUBJID", "VISIT", "VISITNUM"),
	direction = "wide"
)
colnames(dataPlotWide) <- sub("^LBSTRESN.", "", colnames(dataPlotWide))
# scatterplot per visit
scatterplotClinData(
	data = dataPlotWide, 
	xVar = "ALT", yVar = "AST",
	aesPointVar = list(color = "USUBJID", fill = "USUBJID"),
	themePars = list(legend.position = "none"),
	facetPars = list(facets = "VISIT"),
	labelVars = labelVars,
	subtitle = "Visualization is split by visit",
	caption = "Points are colored by subject ID"
)

\dontrun{

# scatterplot with all visits, link subjects
xLab <- getLabelParamcd(paramcd = "ALT", data = dataLB, 
	paramcdVar = "PARAMCD", paramVar = "PARAM")
yLab <- getLabelParamcd(paramcd = "AST", data = dataLB, 
	paramcdVar = "PARAMCD", paramVar = "PARAM")
scatterplotClinData(
	data = dataPlotWide,
	xVar = "ALT", yVar = "AST",
	xLab = xLab,
	yLab = yLab,
	aesPointVar = list(color = "VISIT", fill = "VISIT"),
	aesLineVar = list(group = "USUBJID"),
	labelVars = labelVars
)

# scatterplot of different visits versus baseline

# add baseline as extra column:
dataPlot <- subset(dataLB, PARAMCD == "ALT")
dataPlotBL <- subset(dataPlot, VISIT == "SCREENING 1")
dataPlotBL <- dataPlotBL[with(dataPlotBL, order(USUBJID, -ADY)), ]
dataPlotBL <- dataPlotBL[!duplicated(dataPlotBL$USUBJID), ]
dataPlot$LBSTRESNBL <- dataPlot[match(dataPlot$USUBJID, dataPlotBL$USUBJID), "LBSTRESN"]

# sort visits:
dataPlot$VISIT <- with(dataPlot, reorder(VISIT, VISITNUM))

xLab <- paste(labelVars["LBSTRESN"], "for last screening visit")
yLab <- paste(labelVars["LBSTRESN"], "at visit X")
paramLab <- getLabelParamcd(paramcd = "ALT", data = dataLB, 
	paramcdVar = "PARAMCD", paramVar = "PARAM")
scatterplotClinData(
	data = dataPlot, 
	xVar = "LBSTRESNBL", xLab = xLab,
	yVar = "LBSTRESN", yLab = yLab,
	aesPointVar = list(color = "USUBJID", fill = "USUBJID"),
	aesLineVar = list(group = "USUBJID", color = "USUBJID"),
	hoverVars = c("USUBJID", "VISIT", "ADY", "LBSTRESN"),
	labelVars = labelVars,
	facetPars = list(facets = "VISIT"),
	themePars = list(legend.position = "none"),
	title = paste("Comparison of actual value of", 
		paramLab,
		"at each visit versus baseline"
	),
	refLinePars = list(
		list(slope = 1, intercept = 0, linetype = 1, color = "black", 
			label = FALSE),
		list(yintercept = "A1LO", linetype = 2, color = "blue"),
		list(yintercept = "A1HI", linetype = 2, color = "purple", 
			label = "Reference Range Upper Limit")
	)
)


## scatterplot with smoothing layer

data <- data.frame(
  subj = c(rep('subj1', 20), rep('subj2', 20)),
  time = rep( 1:20 , 2 ),
  response =  c(1:20, 50:31) + runif(min =-3, max = +3, 40),
  treat =  rep(c('trA', 'trB'), 20),
  stringsAsFactors = FALSE
)

# smoothing per subject
smoothPlot <- scatterplotClinData(
  data = data,
  xVar = "time", yVar = "response",
  aesPointVar = list(color = "treat"),
  aesLineVar = list(group = 'subj'),
  linePars = list(linetype='dotted'),
  aesSmoothVar = list(color='subj', group='subj'), 
  smoothPars =  list(alpha=0.5, size=0.3 , se=TRUE, color = 'black')
)
smoothPlot


# plot smoothing over subjects
smoothPlot <- scatterplotClinData(
  data = data,
  xVar = "time", yVar = "response",
  aesPointVar = list(color = "treat"),
  aesLineVar = list(group = 'subj'),
  linePars = list(linetype='dotted'),
  aesSmoothVar = list(), 
  smoothPars =  list(alpha=0.5, size=0.3 , se=TRUE, color = 'black')
)
smoothPlot

}

# add a selection box
if(interactive()){
  dataPlot <- subset(dataLB, PARAMCD == "ALT")
  dataPlot$TRTA <- with(dataPlot, reorder(TRTA, TRTAN))
  scatterplotClinData(
    data = dataPlot, 
    xVar = "ADY",
    yVar = "LBSTRESN",
    aesPointVar = list(fill = "TRTA", color = "TRTA"),
    aesLineVar = list(group = "USUBJID", color = "TRTA"),
    selectVars = "TRTA",
    labelVars = labelVars
  )
}
}
\seealso{
Other Clinical data visualization of individual profiles.: 
\code{\link{timeProfileIntervalPlot}()}
}
\author{
Laure Cougnaud
}
\concept{Clinical data visualization of individual profiles.}
