% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-html.R
\name{convertMdToHtml}
\alias{convertMdToHtml}
\title{Convert the Md file for a specific chapter to html}
\usage{
convertMdToHtml(
  mdFile,
  configFile = NULL,
  indexPath = "index.Rmd",
  intermediateDir = "./interim",
  outputDir = "./report",
  setTitle = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{mdFile}{String with path of the Markdown file}

\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{outputDir}{String with output directory,
('report' by default).}

\item{setTitle}{Logical (TRUE by default), should the title be set 
to the document? If so, the pandoc metadata option: 'pagetitle' is set to:
base file name of \code{mdFile}.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
during the report execution.}

\item{...}{Arguments passed to \code{\link{renderFile}}}
}
\value{
No returned value, the files in the \code{intermediateDir}
are converted to HTML
}
\description{
Convert the Md file for a specific chapter to html
}
\author{
Laure Cougnaud
}
