% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-dimensions.R
\name{getPositionAndMargins}
\alias{getPositionAndMargins}
\title{Get margins and positions of specific
elements for a clinical data plot}
\usage{
getPositionAndMargins(
  title = NULL,
  subtitle = NULL,
  xLab = NULL,
  caption = NULL,
  facet = FALSE,
  includeLegend = TRUE,
  legendPosition = "right"
)
}
\arguments{
\item{title}{String with title for the plot.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{xLab}{String with label for \code{xVar}.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{facet}{Logical, if TRUE the plot
contains facets.}

\item{includeLegend}{Logical, if TRUE (by default)
a legend is available in the plot.}

\item{legendPosition}{String with position of the legend,
among: 'top'/'left'/'bottom'/'right', 'right' by default.}
}
\value{
List with:
\itemize{
\item 'margin': List with bottom ('t') and top ('t') margins in pixels
\item 'position': List with position of the following plot elements:
\itemize{
\item on top of the plot: subtitle and legend
(if positioned at the top).\cr
The position is defined as the distance in pixels
from the top of the plotting area to the bottom
of the element (\code{yanchor = 'bottom'})
\item at the bottom of the plot: caption, xLab
and legend (if positioned at the bottom).\cr
The position is defined as the distance in pixels
from the bottom of the plotting area to the top
of the element (\code{yanchor = 'top'})\cr
Especially, the legend should be positioned with
anchor 'top' such as the margins are automatically
expanded if the legend contains multiple rows.
}
}
}
\description{
The elements are positioned as following:
\itemize{
\item on top of the plot
\enumerate{
\item title
\item subtitle
\item legend, if positioned on top of the plot
\item facet title
}
\item at the bottom of the plot
\enumerate{
\item label for the x-axis
\item legend, if positioned on the bottom of the plot
\item caption
}
}
Margins are computed based on the presence
of these elements.\cr
Only one line is counted for the legend,
as plotly will extend the margin 
if necessary for the legend (for bottom legend).
}
\author{
Laure Cougnaud
}
