% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multichoice.R
\name{combine_multichoice}
\alias{combine_multichoice}
\title{Combine multi-choice columns into one}
\usage{
combine_multichoice(
  df,
  quest_cols,
  sep = ",",
  remove_cols = TRUE,
  remove_prefix = TRUE
)
}
\arguments{
\item{df}{A data frame.}

\item{quest_cols}{A named list where each element is a character vector of column
names to combine, or a single character vector.}

\item{sep}{A string to separate the data. Default is \code{","}.}

\item{remove_cols}{If \code{TRUE}, remove the original columns.}

\item{remove_prefix}{If \code{TRUE}, automatically remove common prefix from column names when combining.}
}
\value{
A data frame with additional columns.
}
\description{
Combine multi-choice columns into one, each column consists of
booleans whether a choice is presented.
}
\examples{
# Single group (backward compatibility)
df <- data.frame(q1 = c(TRUE, FALSE, TRUE), q2 = c(FALSE, TRUE, TRUE))
combine_multichoice(df, quest_cols = c("q1", "q2"))

# Multiple groups with named list
df <- data.frame(
  a1 = c(TRUE, FALSE, TRUE), a2 = c(FALSE, TRUE, TRUE),
  b1 = c(TRUE, TRUE, FALSE), b2 = c(FALSE, FALSE, TRUE)
)
combine_multichoice(df, quest_cols = list(groupA = c("a1", "a2"), groupB = c("b1", "b2")))
}
