% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geno_freq_HWE.R
\name{geno_freq_HWE}
\alias{geno_freq_HWE}
\title{Calculate genotype frequencies from allele frequencies, assuming Hardy-Weinberg equilibrium}
\usage{
geno_freq_HWE(p_alleles, annotate = FALSE)
}
\arguments{
\item{p_alleles}{A vector of strictly positive numbers that sum to \code{1}, with \code{p_alleles[i]}
interpreted as the allele frequency of the \code{i}th allele of the genetic locus.}

\item{annotate}{A logical flag.  When \code{FALSE} (the default), the function returns a
vector suitable to be used as the \code{geno_freq} argument of \code{\link{pedigree_loglikelihood}}.
When \code{TRUE}, the function adds a \code{names} attribute to this vector to indicate which genotype
corresponds to which element.}
}
\value{
A vector of strictly positive numbers (the genotype frequencies)
that sum to \code{1}, with genotype names added when \code{annotate} is \code{TRUE}
}
\description{
A function to calculate the unphased genotype frequencies for a single autosomal genetic locus
that has given allele frequencies and is at Hardy-Weinberg equilibrium (HWE).
}
\details{
For a genetic locus at HWE, the population allele frequencies at
the locus determine the population genotype frequencies; see Section 1.3 of (Lange, 2002).
Given a vector \code{p_alleles} containing the allele frequencies, this function returns
the frequencies of the possible unphased genotypes, in a particular order.
If the alleles are named \code{1:length(p_alleles)}, with \code{p_alleles[i]} being the frequency
of allele \code{i}, then the unphased genotypes are of the form \verb{1/1, 1/2, ...},
and setting \code{annotate} to \code{TRUE} names each element of the output vector with the
corresponding genotype.  Note that if the output of this function is to be used
as the \code{geno_freq} argument of \code{\link{pedigree_loglikelihood}}
then the \code{annotate} option must be set to \code{FALSE}.
}
\examples{
# Genotype frequencies for a biallelic locus at HWE and with a minor allele frequency of 10\%
p_alleles <- c(0.9, 0.1)
geno_freq_HWE(p_alleles, annotate = TRUE)

# Genotype frequencies for a triallelic locus at HWE
p_alleles <- c(0.85, 0.1, 0.05)
geno_freq_HWE(p_alleles, annotate = TRUE)
sum(geno_freq_HWE(p_alleles))
}
\references{
Lange K.  Mathematical and Statistical Methods for Genetic Analysis (second edition).
Springer, New York.  2002.
}
