/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.usermonitor.BadMessageException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class ReadWriteConnection {
    public static int MAX_WRITE_RETRIES = 16;
    public static long RETRY_NAP = 500L;
    private Socket socket;
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    boolean keepReading;

    public ReadWriteConnection(Socket socket, HostType type) throws IOException {
        this.socket = socket;
        if (HostType.server.equals((Object)type)) {
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.oos.flush();
        } else if (HostType.client.equals((Object)type)) {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
        } else {
            throw new RuntimeException("Undefinded HostType=" + (Object)((Object)type));
        }
    }

    public synchronized void writeMessage(Serializable obj) throws Exception {
        Exception z = null;
        for (int i = 0; i < MAX_WRITE_RETRIES; ++i) {
            try {
                this.write(obj);
                if (this.readAck()) {
                    return;
                }
                try {
                    Thread.sleep(RETRY_NAP);
                }
                catch (InterruptedException ix) {}
                continue;
            }
            catch (Exception xxx) {
                if (xxx instanceof RuntimeException && !(xxx instanceof ClassCastException)) {
                    throw (RuntimeException)xxx;
                }
                z = xxx;
            }
        }
        if (z != null) {
            throw z;
        }
        throw new Exception("Write object failed after " + MAX_WRITE_RETRIES + " tries.");
    }

    public Serializable readMessage() throws BadMessageException {
        this.keepReading = true;
        while (this.keepReading) {
            try {
                Serializable obj = this.read();
                this.writeAck(true);
                return obj;
            }
            catch (BadMessageException bx) {
                throw bx;
            }
            catch (Exception xxx) {
                this.writeAck(false);
            }
        }
        return null;
    }

    public void close() {
        try {
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    private void write(Serializable obj) throws Exception {
        this.oos.writeObject(obj);
    }

    private Serializable read() throws BadMessageException {
        try {
            Object obj = this.ois.readObject();
            Serializable s = (Serializable)obj;
            return s;
        }
        catch (Exception xxx) {
            throw new BadMessageException(xxx);
        }
    }

    private void writeAck(boolean b) {
        try {
            this.write(new Boolean(b));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private boolean readAck() throws Exception {
        Boolean ack = (Boolean)this.read();
        return ack;
    }

    public static enum HostType {
        server,
        client;

    }
}

