/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.*;
import com.norbl.cbp.ppe.gui.*;
import com.norbl.util.gui.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author moi
 */
public class AwsClientConfigParamsFrame extends javax.swing.JFrame
    implements ActionListener {

    enum State { active, finished, cancelled };
    
    AwsClientConfigParams acc;
    State state;
    
    public List<LabeledTextField> params;
    
    /**
     * Creates new form AwsClientConfigParamsFrame
     */
    public AwsClientConfigParamsFrame(AwsClientConfigParams acc) {        
        state = State.active;        
        this.acc = acc;
    }
    
    public void go() {
        
        initComponents();
        SwingDefaults.setIcon(this);
        okButton.addActionListener(this);
        okButton.setActionCommand("OK");
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand("Cancel");
        notesLabel.setText(AwsClientConfigParams.getGuiText());
        
        addParams();
        
        GuiUtil.centerOnScreen(this);
        setVisible(true);
    }

    public boolean isActive() { return(state.equals(State.active)); }
    public boolean isCancelled() { return(state.equals(State.cancelled)); }
    
    private void addParams() {
        
        params = new ArrayList<LabeledTextField>();
        
        for ( AwsClientConfigParams.AccParam ap : 
              AwsClientConfigParams.AccParam.values() ) {
            
            String key = ap.toString();
            String val = acc.get(key);
            LabeledTextField p = new LabeledTextField(key);
            if ( val != null ) p.setVal(val);
            p.setAlignmentX(RIGHT_ALIGNMENT);
            params.add(p);
            paramPan.add(p);
        }        
    }
    
    public void actionPerformed(ActionEvent ev) { 
        
        String cmd = ev.getActionCommand();
        
        if ( cmd.equals("Cancel") ) {
            state = State.cancelled;
            this.dispose();
        }
        else if ( cmd.equals("OK") ) {
            state = State.finished;
            this.dispose();
        }
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        framePan = new javax.swing.JPanel();
        textPan = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        notesLabel = new javax.swing.JLabel();
        paramPan = new javax.swing.JPanel();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        framePan.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 1, 16)); // NOI18N
        jLabel1.setText("Amazon Client Configuration Parameters");

        notesLabel.setText("The text");

        javax.swing.GroupLayout textPanLayout = new javax.swing.GroupLayout(textPan);
        textPan.setLayout(textPanLayout);
        textPanLayout.setHorizontalGroup(
            textPanLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(textPanLayout.createSequentialGroup()
                .addComponent(jLabel1)
                .addGap(0, 93, Short.MAX_VALUE))
            .addComponent(notesLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        textPanLayout.setVerticalGroup(
            textPanLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(textPanLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(20, 20, 20)
                .addComponent(notesLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE))
        );

        paramPan.setLayout(new javax.swing.BoxLayout(paramPan, javax.swing.BoxLayout.PAGE_AXIS));

        cancelButton.setText("Cancel");

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout framePanLayout = new javax.swing.GroupLayout(framePan);
        framePan.setLayout(framePanLayout);
        framePanLayout.setHorizontalGroup(
            framePanLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(textPan, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(framePanLayout.createSequentialGroup()
                .addComponent(cancelButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addComponent(paramPan, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        framePanLayout.setVerticalGroup(
            framePanLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(framePanLayout.createSequentialGroup()
                .addComponent(textPan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE)
                .addComponent(paramPan, javax.swing.GroupLayout.PREFERRED_SIZE, 324, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(framePanLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(framePan, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(framePan, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) throws Exception {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
//        GuiMetrics.init();
//        SwingDefaults.setDefaults();
//        AwsClientConfigParams acp = new AwsClientConfigParams();
//        AwsClientConfigParamsFrame f =new AwsClientConfigParamsFrame(acp);
//        acp.editParams();
        
        /*
         * Create and display the form
         */
//        java.awt.EventQueue.invokeLater(new Runnable() {
//
//            public void run() {
//                new AwsClientConfigParamsFrame().setVisible(true);
//            }
//        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel framePan;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel notesLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel paramPan;
    private javax.swing.JPanel textPan;
    // End of variables declaration//GEN-END:variables
}
