/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    @Override
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryRequest> request = new DefaultRequest<QueryRequest>(queryRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.Query";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            Key keyExclusiveStartKey;
            Condition conditionRangeKeyCondition;
            AttributeValue attributeValueHashKeyValue;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (queryRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(queryRequest.getTableName());
            }
            if (queryRequest != null) {
                List<String> attributesToGetList = queryRequest.getAttributesToGet();
                int attributesToGetListIndex = 0;
                if (attributesToGetList != null && attributesToGetList.size() > 0) {
                    jsonWriter.key("AttributesToGet").array();
                    for (String attributesToGetListValue : attributesToGetList) {
                        if (attributesToGetListValue != null) {
                            jsonWriter.value(attributesToGetListValue);
                        } else {
                            jsonWriter.value(null);
                        }
                        ++attributesToGetListIndex;
                    }
                    jsonWriter.endArray();
                }
            }
            if (queryRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(queryRequest.getLimit());
            }
            if (queryRequest.isConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value(queryRequest.isConsistentRead());
            }
            if (queryRequest.isCount() != null) {
                jsonWriter.key("Count").value(queryRequest.isCount());
            }
            if (queryRequest != null && (attributeValueHashKeyValue = queryRequest.getHashKeyValue()) != null) {
                jsonWriter.key("HashKeyValue").object();
                if (attributeValueHashKeyValue.getS() != null) {
                    jsonWriter.key("S").value(attributeValueHashKeyValue.getS());
                }
                if (attributeValueHashKeyValue.getN() != null) {
                    jsonWriter.key("N").value(attributeValueHashKeyValue.getN());
                }
                if (attributeValueHashKeyValue != null) {
                    List<String> sSList = attributeValueHashKeyValue.getSS();
                    int sSListIndex = 0;
                    if (sSList != null && sSList.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList) {
                            if (sSListValue != null) {
                                jsonWriter.value(sSListValue);
                            } else {
                                jsonWriter.value(null);
                            }
                            ++sSListIndex;
                        }
                        jsonWriter.endArray();
                    }
                }
                if (attributeValueHashKeyValue != null) {
                    List<String> nSList = attributeValueHashKeyValue.getNS();
                    int nSListIndex = 0;
                    if (nSList != null && nSList.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList) {
                            if (nSListValue != null) {
                                jsonWriter.value(nSListValue);
                            } else {
                                jsonWriter.value(null);
                            }
                            ++nSListIndex;
                        }
                        jsonWriter.endArray();
                    }
                }
                jsonWriter.endObject();
            }
            if (queryRequest != null && (conditionRangeKeyCondition = queryRequest.getRangeKeyCondition()) != null) {
                List<AttributeValue> attributeValueListList;
                jsonWriter.key("RangeKeyCondition").object();
                if (conditionRangeKeyCondition != null && (attributeValueListList = conditionRangeKeyCondition.getAttributeValueList()) != null && attributeValueListList.size() > 0) {
                    int attributeValueListListIndex = 1;
                    jsonWriter.key("AttributeValueList").array();
                    for (AttributeValue attributeValueListListValue : attributeValueListList) {
                        jsonWriter.object();
                        if (attributeValueListListValue.getS() != null) {
                            jsonWriter.key("S").value(attributeValueListListValue.getS());
                        }
                        if (attributeValueListListValue.getN() != null) {
                            jsonWriter.key("N").value(attributeValueListListValue.getN());
                        }
                        if (attributeValueListListValue != null) {
                            List<String> sSList = attributeValueListListValue.getSS();
                            int sSListIndex = 0;
                            if (sSList != null && sSList.size() > 0) {
                                jsonWriter.key("SS").array();
                                for (String sSListValue : sSList) {
                                    if (sSListValue != null) {
                                        jsonWriter.value(sSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++sSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        if (attributeValueListListValue != null) {
                            List<String> nSList = attributeValueListListValue.getNS();
                            int nSListIndex = 0;
                            if (nSList != null && nSList.size() > 0) {
                                jsonWriter.key("NS").array();
                                for (String nSListValue : nSList) {
                                    if (nSListValue != null) {
                                        jsonWriter.value(nSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++nSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        jsonWriter.endObject();
                        ++attributeValueListListIndex;
                    }
                    jsonWriter.endArray();
                }
                if (conditionRangeKeyCondition.getComparisonOperator() != null) {
                    jsonWriter.key("ComparisonOperator").value(conditionRangeKeyCondition.getComparisonOperator());
                }
                jsonWriter.endObject();
            }
            if (queryRequest.isScanIndexForward() != null) {
                jsonWriter.key("ScanIndexForward").value(queryRequest.isScanIndexForward());
            }
            if (queryRequest != null && (keyExclusiveStartKey = queryRequest.getExclusiveStartKey()) != null) {
                AttributeValue attributeValueRangeKeyElement;
                List<String> nSList;
                List<String> sSList;
                AttributeValue attributeValueHashKeyElement;
                jsonWriter.key("ExclusiveStartKey").object();
                if (keyExclusiveStartKey != null && (attributeValueHashKeyElement = keyExclusiveStartKey.getHashKeyElement()) != null) {
                    jsonWriter.key("HashKeyElement").object();
                    if (attributeValueHashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueHashKeyElement.getS());
                    }
                    if (attributeValueHashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueHashKeyElement.getN());
                    }
                    if (attributeValueHashKeyElement != null) {
                        sSList = attributeValueHashKeyElement.getSS();
                        int sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueHashKeyElement != null) {
                        nSList = attributeValueHashKeyElement.getNS();
                        int nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                if (keyExclusiveStartKey != null && (attributeValueRangeKeyElement = keyExclusiveStartKey.getRangeKeyElement()) != null) {
                    jsonWriter.key("RangeKeyElement").object();
                    if (attributeValueRangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueRangeKeyElement.getS());
                    }
                    if (attributeValueRangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueRangeKeyElement.getN());
                    }
                    if (attributeValueRangeKeyElement != null) {
                        sSList = attributeValueRangeKeyElement.getSS();
                        int sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueRangeKeyElement != null) {
                        nSList = attributeValueRangeKeyElement.getNS();
                        int nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

