/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.services.elasticloadbalancing.model.BackendServerDescription;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.ListenerDescription;
import com.amazonaws.services.elasticloadbalancing.model.Policies;
import com.amazonaws.services.elasticloadbalancing.model.SourceSecurityGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerDescription {
    private String loadBalancerName;
    private String dNSName;
    private String canonicalHostedZoneName;
    private String canonicalHostedZoneNameID;
    private List<ListenerDescription> listenerDescriptions;
    private Policies policies;
    private List<BackendServerDescription> backendServerDescriptions;
    private List<String> availabilityZones;
    private List<String> subnets;
    private String vPCId;
    private List<Instance> instances;
    private HealthCheck healthCheck;
    private SourceSecurityGroup sourceSecurityGroup;
    private List<String> securityGroups;
    private Date createdTime;

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public LoadBalancerDescription withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public String getDNSName() {
        return this.dNSName;
    }

    public void setDNSName(String dNSName) {
        this.dNSName = dNSName;
    }

    public LoadBalancerDescription withDNSName(String dNSName) {
        this.dNSName = dNSName;
        return this;
    }

    public String getCanonicalHostedZoneName() {
        return this.canonicalHostedZoneName;
    }

    public void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
        this.canonicalHostedZoneName = canonicalHostedZoneName;
    }

    public LoadBalancerDescription withCanonicalHostedZoneName(String canonicalHostedZoneName) {
        this.canonicalHostedZoneName = canonicalHostedZoneName;
        return this;
    }

    public String getCanonicalHostedZoneNameID() {
        return this.canonicalHostedZoneNameID;
    }

    public void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
        this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
    }

    public LoadBalancerDescription withCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
        this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        return this;
    }

    public List<ListenerDescription> getListenerDescriptions() {
        if (this.listenerDescriptions == null) {
            this.listenerDescriptions = new ArrayList<ListenerDescription>();
        }
        return this.listenerDescriptions;
    }

    public void setListenerDescriptions(Collection<ListenerDescription> listenerDescriptions) {
        if (listenerDescriptions == null) {
            this.listenerDescriptions = null;
            return;
        }
        ArrayList<ListenerDescription> listenerDescriptionsCopy = new ArrayList<ListenerDescription>(listenerDescriptions.size());
        listenerDescriptionsCopy.addAll(listenerDescriptions);
        this.listenerDescriptions = listenerDescriptionsCopy;
    }

    public LoadBalancerDescription withListenerDescriptions(ListenerDescription ... listenerDescriptions) {
        if (this.getListenerDescriptions() == null) {
            this.setListenerDescriptions(new ArrayList<ListenerDescription>(listenerDescriptions.length));
        }
        for (ListenerDescription value : listenerDescriptions) {
            this.getListenerDescriptions().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withListenerDescriptions(Collection<ListenerDescription> listenerDescriptions) {
        if (listenerDescriptions == null) {
            this.listenerDescriptions = null;
        } else {
            ArrayList<ListenerDescription> listenerDescriptionsCopy = new ArrayList<ListenerDescription>(listenerDescriptions.size());
            listenerDescriptionsCopy.addAll(listenerDescriptions);
            this.listenerDescriptions = listenerDescriptionsCopy;
        }
        return this;
    }

    public Policies getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    public LoadBalancerDescription withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public List<BackendServerDescription> getBackendServerDescriptions() {
        if (this.backendServerDescriptions == null) {
            this.backendServerDescriptions = new ArrayList<BackendServerDescription>();
        }
        return this.backendServerDescriptions;
    }

    public void setBackendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions) {
        if (backendServerDescriptions == null) {
            this.backendServerDescriptions = null;
            return;
        }
        ArrayList<BackendServerDescription> backendServerDescriptionsCopy = new ArrayList<BackendServerDescription>(backendServerDescriptions.size());
        backendServerDescriptionsCopy.addAll(backendServerDescriptions);
        this.backendServerDescriptions = backendServerDescriptionsCopy;
    }

    public LoadBalancerDescription withBackendServerDescriptions(BackendServerDescription ... backendServerDescriptions) {
        if (this.getBackendServerDescriptions() == null) {
            this.setBackendServerDescriptions(new ArrayList<BackendServerDescription>(backendServerDescriptions.length));
        }
        for (BackendServerDescription value : backendServerDescriptions) {
            this.getBackendServerDescriptions().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withBackendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions) {
        if (backendServerDescriptions == null) {
            this.backendServerDescriptions = null;
        } else {
            ArrayList<BackendServerDescription> backendServerDescriptionsCopy = new ArrayList<BackendServerDescription>(backendServerDescriptions.size());
            backendServerDescriptionsCopy.addAll(backendServerDescriptions);
            this.backendServerDescriptions = backendServerDescriptionsCopy;
        }
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public LoadBalancerDescription withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ArrayList<String> subnetsCopy = new ArrayList<String>(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public LoadBalancerDescription withSubnets(String ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ArrayList<String> subnetsCopy = new ArrayList<String>(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public String getVPCId() {
        return this.vPCId;
    }

    public void setVPCId(String vPCId) {
        this.vPCId = vPCId;
    }

    public LoadBalancerDescription withVPCId(String vPCId) {
        this.vPCId = vPCId;
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public LoadBalancerDescription withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public LoadBalancerDescription withHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
        return this;
    }

    public SourceSecurityGroup getSourceSecurityGroup() {
        return this.sourceSecurityGroup;
    }

    public void setSourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup) {
        this.sourceSecurityGroup = sourceSecurityGroup;
    }

    public LoadBalancerDescription withSourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup) {
        this.sourceSecurityGroup = sourceSecurityGroup;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public LoadBalancerDescription withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public LoadBalancerDescription withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName != null) {
            sb.append("LoadBalancerName: " + this.loadBalancerName + ", ");
        }
        if (this.dNSName != null) {
            sb.append("DNSName: " + this.dNSName + ", ");
        }
        if (this.canonicalHostedZoneName != null) {
            sb.append("CanonicalHostedZoneName: " + this.canonicalHostedZoneName + ", ");
        }
        if (this.canonicalHostedZoneNameID != null) {
            sb.append("CanonicalHostedZoneNameID: " + this.canonicalHostedZoneNameID + ", ");
        }
        if (this.listenerDescriptions != null) {
            sb.append("ListenerDescriptions: " + this.listenerDescriptions + ", ");
        }
        if (this.policies != null) {
            sb.append("Policies: " + this.policies + ", ");
        }
        if (this.backendServerDescriptions != null) {
            sb.append("BackendServerDescriptions: " + this.backendServerDescriptions + ", ");
        }
        if (this.availabilityZones != null) {
            sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        }
        if (this.subnets != null) {
            sb.append("Subnets: " + this.subnets + ", ");
        }
        if (this.vPCId != null) {
            sb.append("VPCId: " + this.vPCId + ", ");
        }
        if (this.instances != null) {
            sb.append("Instances: " + this.instances + ", ");
        }
        if (this.healthCheck != null) {
            sb.append("HealthCheck: " + this.healthCheck + ", ");
        }
        if (this.sourceSecurityGroup != null) {
            sb.append("SourceSecurityGroup: " + this.sourceSecurityGroup + ", ");
        }
        if (this.securityGroups != null) {
            sb.append("SecurityGroups: " + this.securityGroups + ", ");
        }
        if (this.createdTime != null) {
            sb.append("CreatedTime: " + this.createdTime + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getDNSName() == null ? 0 : this.getDNSName().hashCode());
        hashCode = 31 * hashCode + (this.getCanonicalHostedZoneName() == null ? 0 : this.getCanonicalHostedZoneName().hashCode());
        hashCode = 31 * hashCode + (this.getCanonicalHostedZoneNameID() == null ? 0 : this.getCanonicalHostedZoneNameID().hashCode());
        hashCode = 31 * hashCode + (this.getListenerDescriptions() == null ? 0 : ((Object)this.getListenerDescriptions()).hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getBackendServerDescriptions() == null ? 0 : ((Object)this.getBackendServerDescriptions()).hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : ((Object)this.getAvailabilityZones()).hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : ((Object)this.getSubnets()).hashCode());
        hashCode = 31 * hashCode + (this.getVPCId() == null ? 0 : this.getVPCId().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : ((Object)this.getInstances()).hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheck() == null ? 0 : this.getHealthCheck().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroup() == null ? 0 : this.getSourceSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getDNSName() == null ^ this.getDNSName() == null) {
            return false;
        }
        if (other.getDNSName() != null && !other.getDNSName().equals(this.getDNSName())) {
            return false;
        }
        if (other.getCanonicalHostedZoneName() == null ^ this.getCanonicalHostedZoneName() == null) {
            return false;
        }
        if (other.getCanonicalHostedZoneName() != null && !other.getCanonicalHostedZoneName().equals(this.getCanonicalHostedZoneName())) {
            return false;
        }
        if (other.getCanonicalHostedZoneNameID() == null ^ this.getCanonicalHostedZoneNameID() == null) {
            return false;
        }
        if (other.getCanonicalHostedZoneNameID() != null && !other.getCanonicalHostedZoneNameID().equals(this.getCanonicalHostedZoneNameID())) {
            return false;
        }
        if (other.getListenerDescriptions() == null ^ this.getListenerDescriptions() == null) {
            return false;
        }
        if (other.getListenerDescriptions() != null && !((Object)other.getListenerDescriptions()).equals(this.getListenerDescriptions())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getBackendServerDescriptions() == null ^ this.getBackendServerDescriptions() == null) {
            return false;
        }
        if (other.getBackendServerDescriptions() != null && !((Object)other.getBackendServerDescriptions()).equals(this.getBackendServerDescriptions())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !((Object)other.getAvailabilityZones()).equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !((Object)other.getSubnets()).equals(this.getSubnets())) {
            return false;
        }
        if (other.getVPCId() == null ^ this.getVPCId() == null) {
            return false;
        }
        if (other.getVPCId() != null && !other.getVPCId().equals(this.getVPCId())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !((Object)other.getInstances()).equals(this.getInstances())) {
            return false;
        }
        if (other.getHealthCheck() == null ^ this.getHealthCheck() == null) {
            return false;
        }
        if (other.getHealthCheck() != null && !other.getHealthCheck().equals(this.getHealthCheck())) {
            return false;
        }
        if (other.getSourceSecurityGroup() == null ^ this.getSourceSecurityGroup() == null) {
            return false;
        }
        if (other.getSourceSecurityGroup() != null && !other.getSourceSecurityGroup().equals(this.getSourceSecurityGroup())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }
}

