/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ChecksumValidatingInputStream
extends FilterInputStream {
    private final byte[] expectedChecksum;
    private final DigestInputStream digestInputStream;
    private final String sourceObject;
    private boolean hasReadAllContent = false;

    public ChecksumValidatingInputStream(InputStream in, byte[] expectedChecksum, String sourceObject) throws NoSuchAlgorithmException {
        super(new DigestInputStream(in, MessageDigest.getInstance("MD5")));
        this.expectedChecksum = expectedChecksum;
        this.sourceObject = sourceObject;
        this.digestInputStream = (DigestInputStream)this.in;
    }

    public int read() throws IOException {
        int read = super.read();
        this.hasReadAllContent = read == -1;
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.hasReadAllContent = read == 0;
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.hasReadAllContent = read == 0;
        return read;
    }

    public void close() throws IOException {
        super.close();
        if (!this.hasReadAllContent) {
            return;
        }
        byte[] clientSideHash = this.digestInputStream.getMessageDigest().digest();
        if (!Arrays.equals(clientSideHash, this.expectedChecksum)) {
            throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data read from '" + this.sourceObject + "' may be corrupt.");
        }
    }
}

