/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.AbstractS3ResponseHandler;
import com.amazonaws.services.s3.internal.ChecksumValidatingInputStream;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.BinaryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ObjectResponseHandler
extends AbstractS3ResponseHandler<S3Object> {
    @Override
    public AmazonWebServiceResponse<S3Object> handle(HttpResponse response) throws Exception {
        boolean responseContainsEntireObject;
        S3Object object = new S3Object();
        ObjectMetadata metadata = object.getObjectMetadata();
        this.populateObjectMetadata(response, metadata);
        boolean hasServerSideCalculatedChecksum = !ServiceUtils.isMultipartUploadETag(metadata.getETag());
        boolean bl = responseContainsEntireObject = response.getHeaders().get("Content-Range") == null;
        if (hasServerSideCalculatedChecksum && responseContainsEntireObject) {
            byte[] expectedChecksum = BinaryUtils.fromHex(metadata.getETag());
            object.setObjectContent(new S3ObjectInputStream(new ChecksumValidatingInputStream(response.getContent(), expectedChecksum, object.getBucketName() + "/" + object.getKey()), response.getHttpRequest()));
        } else {
            object.setObjectContent(new S3ObjectInputStream(response.getContent(), response.getHttpRequest()));
        }
        AmazonWebServiceResponse<S3Object> awsResponse = this.parseResponseMetadata(response);
        awsResponse.setResult(object);
        return awsResponse;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return true;
    }
}

