/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.annotations.Asynchronous;
import com.amazonaws.services.simpleworkflow.flow.annotations.NoWait;
import com.amazonaws.services.simpleworkflow.flow.annotations.Wait;
import com.amazonaws.services.simpleworkflow.flow.aspectj.AsynchronousAspectTask;
import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class AsynchronousAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AsynchronousAspect ajc$perSingletonInstance;

    @Around(value="call(@com.amazonaws.services.simpleworkflow.flow.annotations.Asynchronous * *(..)) && @annotation(asynchronousAnnotation)")
    public Object makeAsynchronous(ProceedingJoinPoint pjp, Asynchronous asynchronousAnnotation) throws Throwable {
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            int i = 0;
            Object[] methodArguments = pjp.getArgs();
            Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
            ArrayList<Promise> valueParams = new ArrayList<Promise>();
            Class[] classArray = methodSignature.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class parameterType = classArray[n2];
                if ((AsynchronousAspect.isPromise(parameterType) || AsynchronousAspect.isPromiseArray(parameterType) || AsynchronousAspect.isCollection(parameterType) && AsynchronousAspect.hasWaitAnnotation(parameterAnnotations[i])) && !AsynchronousAspect.hasNoWaitAnnotation(parameterAnnotations[i])) {
                    Object param = methodArguments[i];
                    if (AsynchronousAspect.isPromise(parameterType)) {
                        valueParams.add((Promise)param);
                    } else if (AsynchronousAspect.isCollection(parameterType)) {
                        valueParams.add(new AndPromise((Collection)param));
                    } else {
                        valueParams.add(new AndPromise((Promise[])param));
                    }
                } else {
                    valueParams.add(null);
                }
                ++i;
                ++n2;
            }
            Promise[] values = valueParams.toArray(new Promise[0]);
            Boolean daemon = asynchronousAnnotation.daemon() ? Boolean.valueOf(true) : null;
            AsynchronousAspectTask task = new AsynchronousAspectTask(daemon, pjp, values);
            return task.getReturnValue();
        }
        return pjp.proceed();
    }

    private static boolean isPromise(Class<?> clazz) {
        return Promise.class.isAssignableFrom(clazz);
    }

    private static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private static boolean isPromiseArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> elementType = clazz.getComponentType();
        return AsynchronousAspect.isPromise(elementType);
    }

    private static boolean hasWaitAnnotation(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(Wait.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasNoWaitAnnotation(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(NoWait.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static AsynchronousAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.amazonaws.services.simpleworkflow.flow.aspectj.AsynchronousAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            AsynchronousAspect.ajc$perSingletonInstance = new AsynchronousAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

