% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud-storage.R
\name{gs_copy}
\alias{gs_copy}
\title{Copy files to / from Google Storage}
\usage{
gs_copy(source, destination, recursive = FALSE, echo = TRUE)
}
\arguments{
\item{source}{The file to be copied. This can be either a path on the local
filesystem, or a Google Storage URI (e.g. \code{gs://[BUCKET_NAME]/[FILENAME.CSV]}).}

\item{destination}{The location where the \code{source} file should be copied to. This can be
either a path on the local filesystem, or a Google Storage URI (e.g.
\code{gs://[BUCKET_NAME]/[FILENAME.CSV]}).}

\item{recursive}{Boolean; perform a recursive copy? This must be specified if you intend on
copying directories.}

\item{echo}{Echo command output to console.}
}
\description{
Use the \code{gsutil cp} command to copy data between your local file system and
the cloud, copy data within the cloud, and copy data between cloud storage
providers.
}
