% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma-mv.R
\name{vcovCR.rma.mv}
\alias{vcovCR.rma.mv}
\title{Cluster-robust variance-covariance matrix for a robu object.}
\usage{
\method{vcovCR}{rma.mv}(obj, cluster, type, target, inverse_var,
  form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Optional expression or vector indicating which observations 
belong to the same cluster. If not specified, will be set to the factor in
the random-effects structure with the fewest distinct levels. Caveat
emptor: the function does not check that the random effects are nested.}

\item{type}{Character string specifying which small-sample adjustment should 
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1S"}, 
\code{"CR2"}, or \code{"CR3"}. See "Details" section of
\code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working 
variance-covariance model used to calculate the \code{CR2} and \code{CR4} 
adjustment matrices. If not specified, the target is taken to be the 
estimated variance-covariance structure of the \code{rma.mv} object.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists 
  of a matrix of the estimated variance of and covariances between the 
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from a 
\code{\link[metafor]{rma.mv}} object.
}
\examples{
library(metafor)
data(hierdat, package = "robumeta")

mfor_fit <- rma.mv(effectsize ~ binge + followup + sreport + age, 
                 V = var, random = list(~ 1 | esid, ~ 1 | studyid),
                 data = hierdat)
mfor_fit

mfor_CR2 <- vcovCR(mfor_fit, type = "CR2")
mfor_CR2
coef_test(mfor_fit, vcov = mfor_CR2, test = c("Satterthwaite", "saddlepoint"))

Wald_test(mfor_fit, constraints = c(2,4), vcov = mfor_CR2)
Wald_test(mfor_fit, constraints = 2:5, vcov = mfor_CR2)
}
\seealso{
\code{\link{vcovCR}}
}

