% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{angle_btw}
\alias{angle_btw}
\title{Angle between two \mjseqn{n}-dimensional vectors.}
\usage{
angle_btw(v1, v2)
}
\arguments{
\item{v1}{First vector.}

\item{v2}{Second vector.}
}
\value{
Angle between \code{v1} and \code{v2} in radians.
}
\description{
\loadmathjax
Typically, the angle between two vectors \code{v1} and \code{v2} can be obtained with:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{acos((v1 \%*\% v2) / (norm(v1, "2") * norm(v2, "2")))
}\if{html}{\out{</div>}}

However, this approach is numerically unstable. The version provided here is
numerically stable and based on the \href{https://github.com/JeffreySarnoff/AngleBetweenVectors.jl}{Angle Between Vectors}
Julia package by Jeffrey Sarnoff (MIT license), implementing an algorithm
provided by Prof. W. Kahan in
\href{https://people.eecs.berkeley.edu/~wkahan/MathH110/Cross.pdf}{these notes}
(see page 15).
}
\examples{
angle_btw(c(1.0, 1.0, 1.0, 1.0), c(1.0, 0.0, 0.0, 0.0)) * 180 / pi
}
