% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusWilcox.R
\name{clusWilcox.test}
\alias{clusWilcox.test}
\alias{clusWilcox.test.formula}
\alias{clusWilcox.test.default}
\title{Wilcoxon Rank Sum and Signed Rank Test for Clustered Data}
\usage{
clusWilcox.test(x, ...)

\method{clusWilcox.test}{formula}(formula, data = parent.frame(),
  subset = NULL, na.action = na.omit, alternative = c("two.sided", "less",
  "greater"), mu = 0, paired = FALSE, exact = FALSE, B = 2000,
  method = c("rgl", "ds", "dd"), ...)

\method{clusWilcox.test}{default}(x, y = NULL, cluster = NULL,
  group = NULL, stratum = NULL, data = NULL,
  alternative = c("two.sided", "less", "greater"), mu = 0, paired = FALSE,
  exact = FALSE, B = 2000, method = c("rgl", "ds", "dd"), ...)
}
\arguments{
\item{x}{A numeric vector of data values or a formula. Non-finite (e.g.,
infinite or missing) values will be omitted.}

\item{...}{Further arguments to be passed to or from methods.}

\item{formula}{A formula of the form \code{lhs ~ rhs} where the
\code{lhs} is the measurements and
the \code{rhs} is of the form group + \code{cluster}(x1) +
\code{stratum}(x2) for clustered rank sum test, where
\code{x1} and \code{x2} are cluster id and stratum id in the
data frame \code{data}. For clustered signed rank test, the
\code{rhs} only contains \code{cluster}{x1}.}

\item{data}{An optional data frame containing the variables.}

\item{subset}{An optional vector specifying a subset of
observations to be used.}

\item{na.action}{A function which indicates what should happen
when the data contain NAs. Defaults to \code{getOption("na.action")}.}

\item{alternative}{A character string specifying the alternative
hypothesis, must be one of \code{"two sided"} (default),
\code{"greater"} or \code{"less"}. You can specify just the
initial letter.}

\item{mu}{A number specifying an optional parameter used to form
the null hypothesis. Default is 0. See 'Details'.}

\item{paired}{A logical indicating whether you want a paired test.}

\item{exact}{A logical indicating if a permutation test is to be
used. If it is set as \code{FALSE}, then test based on
large-sample theory is carried out. If it is set as
\code{TRUE}, then a permutation test is carried out. There are
two available permutation tests: exact permutation test is available for
\code{rgl} signed rank test and \code{rgl} rank sum test when
treatment is assigned at cluster level, random permutation
test is available for all tests. For more details look at the
description of the argument \code{B}.}

\item{B}{An integer specifying the number of permutations if exact = TRUE.
If B = 0, then the test is the exact permutation test.
If B > 0, then an approximation to the exact test with B random permutation.
Default is set as 2000 to ran a random permutation test.}

\item{method}{A character string specifying the method of
clustered Wilcoxon rank test to be use, should be one of
\code{"rgl"} or \code{"ds"}. For rank-sum test, the \code{"dd"}
method is also available.}

\item{y}{An optional numeric vector of data values, non-finite
values will be omitted.}

\item{cluster}{An optional numeric vector of cluster id.}

\item{group}{An optional numeric vector of treatment id.}

\item{stratum}{An optional numeric vector of stratum id. Only
available for \code{rgl} rank sum test when treatment is assigned at
    cluster level.}
}
\value{
A list with class \code{"htest"} containing the following components,
for different test the components may vary:
\item{Rstat}{the value of the rank statistic with a name describing it.}
\item{ERstat}{the expectation of the rank statistic.}
\item{VRstat}{the variance of the rank statistic.}
\item{statistic}{the value of the test statistic with a name describing it.}
\item{p.value}{the p-value for the test.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{null.value}{the location parameter 'mu'.}
\item{method}{the type of test applied.}
\item{data.name}{a character string giving the names of the data.}
\item{balance}{a logical indicating whether the data set is balanced.}
\item{ngroup}{number of treatment, will be returned if there are more than 2 treatment groups and \code{ds} method is used.}
\item{df}{degrees of freedom of chi-square distribution, will be returned when there are more than 2 treatment groups and \code{ds} method is used.}
\item{nobs}{number of observations}
\item{nclus}{number of clusters}
}
\description{
Performs one-sample and two-sample Wilcoxon test for clustered data
on vectors of data.
}
\details{
The formula interface is to both clustered signed rank
    test and clustered rank sum test.


The default of \code{cluster} id is that there is one member in
    each cluster. Both balanced data (identical cluster size) and
    unbalanced data (different cluster sizes) are
    supported in all tests provided in this package. For clustered
    rank sum test, the data can either have treatment assigned at
    cluster level or individual level.

If both \code{x} and \code{y} are given or only \code{x} is given
    and \code{paired} is \code{TRUE}, a clustered Wilcoxon signed
    rank test of the null that the distribution of \code{x - y}
    (paired sample) or of \code{x} (one sample) is symmetric about
    \code{mu} is performed.

Otherwise, if only \code{x} is given and \code{paired} is
\code{FALSE}, a Wilcoxon rank sum test is performed. In this case,
measurements from different treatment groups should be combined in
\code{x} and the \code{group} variable is required.  When there
are two treatment groups, the null is that the distributions of
values from the two groups differ by a location shift of \code{mu}
and the alternative is that they differ by some other location
shift.  When there are \code{m} (>= 2) treatment groups, \code{ds}
method can test if the location of the \code{m} groups are
identical or not.

For RGL rank sum test when treatment is assigned at cluster level,
    an extra stratification variable is allowed through \code{stratum}.

The exact test is only available for RGL signed rank test and  RGL
    rank sum test when treatment is assigned at cluster level.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: \code{S3} method for class 'formula'

\item \code{default}: Default \code{S3} method.
}}

\section{Warning}{

This function can use large amounts of memory and stack if 'exact =
    TRUE' and one sample is large (and even crash R if the stack
    limit is exceeded). Not recommended for data set
    with number of clusters more than 50.
}

\examples{
## Clustered signed rank test using RGL method.
data(crsd)
clusWilcox.test(z, cluster = id, data = crsd, paired = TRUE, method = "rgl")
## or
clusWilcox.test(z ~ cluster(id), data = crsd, paired = TRUE, method = "rgl")
\dontrun{clusWilcox.test(z, cluster = id, data = crsd)
## Default is rank sum test. The group variable is required.}
## Clustered rank sum test using RGL method.
data(crd)
clusWilcox.test(z ~ group + cluster(id), data = crd, method = "rgl")
## or
clusWilcox.test(z, cluster = id, group = group, data = crd, method = "rgl")
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2006)
\emph{The Wilcoxon Signed Rank Test for Paired Comparisons of
 Clustered Data}. Biometrics, \bold{62}, 185-192.

Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2003)
\emph{Incorporation of Clustering Effects for the Wilcoxon Rank
Sum Test: A Large-Sample Approach}. Biometrics, \bold{59}, 1089-1098.

Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2006)
\emph{Extension of the Rank Sum Test for Clustered Data:
Two-Group Comparisons with Group}. Biometrics, \bold{62}, 1251-1259.

Somnath Datta, Glen A. Satten (2005) \emph{Rank-Sum Tests for Clustered Data}.
Journal of the American Statistical Association, \bold{100}, 908-915.

Somath Datta, Glen A. Satten (2008) \emph{A Signed-Rank Test for Clustered Data}.
Biometrics, \bold{64}, 501-507.

Sandipan Dutta, Somnath Datta (2015) \emph{A Rank-Sum Test for Clustered
    Data When the Number of Subjects in a Group within a Cluster is
    Informative}.
Biometrics, \bold{72}, 432-440.
}
\author{
Yujing Jiang
}
