% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barabasi_albert.R
\encoding{UTF-8}
\name{barabasi_albert_blocks}
\alias{barabasi_albert_blocks}
\title{Generates a Barabási-Albert graph with community structure}
\usage{
barabasi_albert_blocks(
  m,
  p,
  B,
  t_max,
  G0 = NULL,
  t0 = NULL,
  G0_labels = NULL,
  sample_with_replacement = FALSE,
  type = "Hajek"
)
}
\arguments{
\item{m}{number of edges added at each step.}

\item{p}{vector of label probabilities. If they don't sum 1, they will be scaled accordingly.}

\item{B}{matrix indicating the affinity of vertices of each label.}

\item{t_max}{maximum value of t (which corresponds to graph order)}

\item{G0}{initial graph}

\item{t0}{t value at which new vertex start to be attached. If G0 is provided,
this argument is ignored and assumed to be gorder(G0)+1. If it isn't, a G0
graph will be generated with order t0-1.}

\item{G0_labels}{labels of the initial graph. If NULL, they will all be set to 1.}

\item{sample_with_replacement}{If TRUE, allows parallel edges.}

\item{type}{Either "Hajek" or "block_first".}
}
\value{
The resulting graph, as an igraph object. The vertices have a
"label" attribute.
}
\description{
Generates a Barabási-Albert graph with community structure
}
\examples{
B <- matrix(c(1, 0.2, 0.2, 1), ncol=2)
G <- barabasi_albert_blocks(m=4, p=c(0.5, 0.5), B=B, t_max=100, type="Hajek", 
                            sample_with_replacement = FALSE)

}
