% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotonePatternClustering.R
\name{monotonePatternClustering}
\alias{monotonePatternClustering}
\title{clustering dose-response curves based on their pattern when it is 
known to be monotone.
function to cluster dose-response curves based on their pattern.}
\usage{
monotonePatternClustering(inputData, colsData, colID, doseLevels,
  numReplications, transform = c("none", "log", "sRoot", "qRoot",
  "boxcox"), BHorBY = TRUE, SAM = FALSE, testType = c("E2",
  "Williams", "Marcus", "M", "ModifM"), adjustType = c("BH", "BY"),
  FDRvalue = c(0.05, 0.05), nPermute = c(1000, 1000),
  fudgeSAM = c("pooled", "none"), useSeed = c(NULL, NULL),
  theLeastNumberOfTests = 5, na.rm = FALSE,
  imputationMethod = c("mean", "median"))
}
\arguments{
\item{inputData}{data matrix which should incluide ID's of the subjects, as well as the measurements (gene expressions, etc.) 
for all replications of different as columns.}

\item{colsData}{vector indicating the idex of columns in the inputData which correspond to the measurement for different replications 
of different doses.}

\item{colID}{scalar indicating the index of column corresponding to data ID.}

\item{doseLevels}{vector with dose levels.}

\item{numReplications}{vector wit hthe same length as doseLevels with number of replications for each dose.}

\item{transform}{single string indicating what kind of transform should be applied on the response data. 
It takes "none" (no transform, dafault), "log" (natural log), "sRoot (square root), and "qRoot" (cubic root), and 
"boxcox" (Box-Cox transformation).}

\item{BHorBY}{logical inidicating whether monotonicity tests (specified in argument testType) using BH or BY modifications 
should be performed. Default is TRUE.}

\item{SAM}{logical indicating whether a SAM procedure should be perfmored. Default is FALSE.}

\item{testType}{string a subset of c("E2", "Williams", "Marcus", "M", "ModifM"), indicating the monotonicity tests 
which should be applied.}

\item{adjustType}{method of adjustment for multi-plicity in case BHorBY = TRUE. It takes values "BH" abd "BY" with "BH" as the
default.}

\item{FDRvalue}{a numerical vector of length 2 indicating the FDR values for BHorBY and SAM, the default is 0.05 for both.}

\item{nPermute}{a numerical vector of length 2 indicating number of permutatation for BHorBY and SAM, the default for 
both is 1000.}

\item{fudgeSAM}{single string takes value from ("pooled", "none") specified the fudge factor in SAM test statistic. 
The default is "pooled".}

\item{useSeed}{a vector of lkength two specifying the seed value for BHorBY and SAM, the default is NULL for both.}

\item{theLeastNumberOfTests}{A scalar indicating the minimum number of tests which should approve a monotone trend to 
consider a trend montone. The default is 5, i.e., all of the tests should agree on the monotonicity.}

\item{na.rm}{logical variable indicatign whether missing values should be removed (TRUE) or not (FALSE, default)}

\item{imputationMethod}{signle string taking calues from "mean" (default), and "median", which indicates how the missing values should be
treated. "mean" would replace them with the mean of the observed ones, and "median" will use median of them for imputation.}
}
\value{
a list with the following objects:

selectedSubjects: provides the ID and indentified patterns for the subjects which are selected based on the results of 
various tests and theLeastNumberOfTests.

subjectsPatterns: a vector of the same length as the number of subjects in the input dataset which indicates the identified
patterns for all subjects (including flat ones).

resultsBH: a list with the results of selected tests (if BHorBY = TRUE, NULL otherwise).

resultsSAM: a list with results of SAM procedure (if SAM = TRUE, NULL otherwise).

selectedSubjectsBH: a data frame of all of the subjects with then number of tests select them based on adjusted BH or BY methods.

selectedSubjectsSAM: a data frame of all of the subjects with then number of tests select them based on SAM procedure
}
\description{
clustering dose-response curves based on their pattern when it is 
known to be monotone.
function to cluster dose-response curves based on their pattern.
}
\examples{
## gnerating data, a sample of size 20
set.seed(11)
doses2Use <-  c(0, 5, 20)
numRep2Use <- c(3, 3, 3)
generatedData <- cbind(rep(1,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), 
doses2Use, numRep2Use, 1), 
		matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(generatedData) <- c("ID", "dose", "response", "x1")
for (iGen in 2:20){
	genData0 <- cbind(rep(iGen,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), 
doses2Use, numRep2Use, 1), 
			matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
	colnames(genData0) <- c("ID", "dose", "response", "x1")
	generatedData <- rbind(generatedData, genData0)
}
## transforming it for clustering
toInput <- inputDataMaker(2, 3, 1, generatedData)
## monotone pattern clustering
monotonePatternClust <- monotonePatternClustering (inputData = 
toInput$inputData, colsData = toInput$colsData ,
		colID = toInput$colID, doseLevels = toInput$doseLevels, 
numReplications = toInput$numReplicates, 
		BHorBY = TRUE, SAM = FALSE, testType = c("E2"),
		adjustType = "BH", FDRvalue = c(0.05, 0.05), 
nPermute= c(100, 100), fudgeSAM = "pooled",
		useSeed = c(NULL, NULL), theLeastNumberOfTests = 1, 
na.rm = FALSE, imputationMethod = "mean")

}
\seealso{
\href{https://www.rdocumentation.org/packages/IsoGene/versions/1.0-24/topics/IsoTestBH}{IsoGene}
\href{https://www.rdocumentation.org/packages/IsoGene/versions/1.0-24/topics/IsoTestSAM}{IsoGene}
\href{https://www.rdocumentation.org/packages/ORCME/versions/2.0.2/topics/monotoneDirection}{ORCME}
}
\author{
Vahid Nassiri, and Yimer Wasihun.
}
