% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.clustcurves.R
\name{summary.clustcurves}
\alias{summary.clustcurves}
\title{Summarizing fits of \code{kclustcurves} class produced by \code{survclustcurves} and
\code{regclustcurves}}
\usage{
\method{summary}{clustcurves}(object, ...)
}
\arguments{
\item{object}{a clustcurves object as producted by \code{survclustcurves} and
\code{regclustcurves}}

\item{\ldots}{additional arguments.}
}
\value{
\code{summary.clustcurves} computes and returns a list of summary
information for a \code{clustcurves} object.
\item{levels}{Levels of the factor.}
\item{cluster}{A vector containing the assignment of each factor's level to its group.}
\item{table}{A data.frame containing the results from the hypothesis test.}
}
\description{
Takes a  clustcurves object
and produces various useful summaries from it.
}
\details{
\code{print.clustcurves} tries to be smart about \code{summary.clustcurves}.
}
\examples{
library(clustcurv)
library(survival)
library(condSURV)
data(veteran)
data(colonCS)

# Survival framework
ressurv <- survclustcurves(time = veteran$time, status = veteran$status,
x = veteran$celltype, algorithm = 'kmeans', nboot = 2)

summary(ressurv)


# Regression framework
resreg <- regclustcurves(y = barnacle5$DW, x = barnacle5$RC, z = barnacle5$F,
algorithm = 'kmeans', nboot = 2)

summary(resreg)



}
\author{
Nora M. Villanueva and Marta Sestelo.
}
