% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midpt.R
\name{midpt}
\alias{midpt}
\title{rectangle method}
\usage{
midpt(f, a, b, m = 100)
}
\arguments{
\item{f}{function to integrate}

\item{a}{the a-bound of integration}

\item{b}{the b-bound of integration}

\item{m}{the number of subintervals to calculate}
}
\value{
the value of the integral
}
\description{
Use the rectangle method to integrate a function
}
\details{
The \code{midpt} function uses the rectangle method to calculate
the integral of the function \code{f} over the interval from
\code{a} to \code{b}.  The parameter \code{m} sets the number
of intervals to use when evaluating the rectangles.  Additional
options are passed to the function \code{f} when evaluating.
}
\examples{
f <- function(x) { sin(x)^2 + cos(x)^2 }
midpt(f, -pi, pi, m = 10)
midpt(f, -pi, pi, m = 100)
midpt(f, -pi, pi, m = 1000)

}
\seealso{
Other integration: \code{\link{adaptint}},
  \code{\link{gaussint}}, \code{\link{giniquintile}},
  \code{\link{mcint}}, \code{\link{revolution-solid}},
  \code{\link{romberg}}, \code{\link{simp38}},
  \code{\link{simp}}, \code{\link{trap}}

Other newton-cotes: \code{\link{adaptint}},
  \code{\link{giniquintile}}, \code{\link{romberg}},
  \code{\link{simp38}}, \code{\link{simp}},
  \code{\link{trap}}
}
\concept{integration}
\concept{newton-cotes}
