% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.diff.R
\name{cmsaf.diff}
\alias{cmsaf.diff}
\title{Plotting routine designed for the CM SAF R Toolbox.}
\usage{
cmsaf.diff(
  var1,
  infile1,
  var2,
  infile2,
  outfile,
  plot.out = FALSE,
  relative = FALSE,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  toolbox = FALSE
)
}
\arguments{
\item{var1}{Name of the first NetCDF variable (character).}

\item{infile1}{Filename of the first input NetCDF file. This may include the directory
(character).}

\item{var2}{Name of the second NetCDF variable (character).}

\item{infile2}{Filename of the second input NetCDF file. This may include the directory
(character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{plot.out}{logical; if TRUE, the plot will be stored in the same folder as outfile.
If FALSE, the plot will not be saved.}

\item{relative}{logical; if TRUE, plot a relative difference plot}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{toolbox}{logical; if TRUE, toolbox mode enabled. The two files are adjusted in space
and time so that they can be plotted.}
}
\value{
A NetCDF file is written.
}
\description{
This function renders a difference plot (absolute or relative) of two variables.
}
\seealso{
Other 2d visualization: 
\code{\link{cmsaf.side.by.side}()}
}
\concept{2d visualization}
