% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adtest.R
\name{glance.anderson_darling}
\alias{glance.anderson_darling}
\title{Glance at an \code{anderson_darling} object}
\usage{
\method{glance}{anderson_darling}(x, ...)
}
\arguments{
\item{x}{an \code{anderson_darling} object}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
A one-row \code{\link[tibble:tibble]{tibble::tibble}} with the following
columns:

\item{\code{dist}}{the distribution used}
\item{\code{n}}{the number of observations in the sample}
\item{\code{A}}{the Anderson--Darling test statistic}
\item{\code{osl}}{the observed significance level (p-value),
    assuming the
    parameters of the distribution are estimated from the data}
 \item{\code{alpha}}{the required significance level for the test.
   This value is given by the user.}
\item{\code{reject_distribution}}{a logical value indicating whether
   the hypothesis that the data is drawn from the specified distribution
   should be rejected}
}
\description{
Glance accepts an object of type \code{anderson_darling} and
returns a \code{\link[tibble:tibble]{tibble::tibble}} with
one row of summaries.

Glance does not do any calculations: it just gathers the results in a
tibble.
}
\examples{
x <- rnorm(100, 100, 4)
ad <- anderson_darling_weibull(x = x)
glance(ad)

## # A tibble: 1 x 6
##   dist        n     A        osl alpha reject_distribution
##   <chr>   <int> <dbl>      <dbl> <dbl> <lgl>
## 1 Weibull   100  2.62 0.00000207  0.05 TRUE

}
\seealso{
\code{\link{anderson_darling}}
}
