% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.tab.ps.R
\name{bal.tab.ps}
\alias{bal.tab.ps}
\title{Balance Statistics for \code{twang} Objects}
\usage{
\method{bal.tab}{ps}(
  x,
  stop.method,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  data = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{ps}, \code{mnps}, \code{iptw}, or \code{ps.cont} object; the output of a call to \pkgfun{twang}{ps}, \pkgfun{twang}{mnps}, \pkgfun{twang}{iptw} or \pkgfun{twangContinuous}{ps.cont}.}

\item{stop.method}{a string containing the names of the stopping methods used in the original call to \code{ps()}, \code{mnps()}, or \code{iptw()}. Examples include \code{"es.max"} or \code{"ks.mean"} for \code{ps} and \code{mnps} objects. \code{bal.tab()} will assess balance for the weights created by those stopping methods. The names can be abbreviated as long as the abbreviations are specific enough. If no stopping methods are provided, \code{bal.tab()} will default to displaying balance for all available stopping methods. Ignored for \code{ps.cont} objects.}

\item{stats}{\code{character}; which statistic(s) should be reported. See \code{\link[=balance-statistics]{stats}} for allowable options. For binary and multi-category treatments, \code{"mean.diffs"} (i.e., mean differences) is the default. For continuous treatments, \code{"correlations"} (i.e., treatment-covariate Pearson correlations) is the default. Multiple options are allowed.}

\item{int}{\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well.}

\item{poly}{\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.}

\item{distance}{an optional formula or data frame containing distance values (e.g., propensity scores) or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the argument to \code{data}, if specified. The propensity scores generated by \code{ps()} and \code{iptw()} (but not \code{mnps()} or \code{ps.cont()}) are automatically included and named "prop.score.{stop.method}".}

\item{addl}{an optional formula or data frame containing additional covariates for which to present balance or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the arguments to the input object, \code{covs}, and \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{data}{an optional data frame containing variables named in other arguments. For some input object types, this is required.}

\item{continuous}{whether mean differences for continuous variables should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"std"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{binary}{whether mean differences for binary variables (i.e., difference in proportion) should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"raw"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{s.d.denom}{\code{character}; how the denominator for standardized mean differences should be calculated, if requested. See \code{\link[=col_w_smd]{col_w_smd()}} for allowable options. Abbreviations allowed. If not specified, for \code{ps} objects, \code{bal.tab()} will use "treated" if the estimand of the call to \code{ps()} is the ATT and "pooled" if the estimand is the ATE; for \code{mnps} objects, \code{bal.tab()} will use "treated" if \code{treatATT} was specified in the original call to \code{mnps} and "pooled" otherwise. Use "all" to get the same values computed by \code{bal.table()} in \pkg{twang}.}

\item{thresholds}{a named vector of balance thresholds, where the name corresponds to the statistic (i.e., in \code{stats}) that the threshold applies to. For example, to request thresholds on mean differences and variance ratios, one can set \code{thresholds = c(m = .05, v = 2)}. Requesting a threshold automatically requests the display of that statistic. When specified, extra columns are inserted into the Balance table describing whether the requested balance statistics exceeded the threshold or not. Summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure are added to the output.}

\item{weights}{a vector, list, or \code{data.frame} containing weights for each unit, or a string containing the names of the weights variables in \code{data}, or an object with a \code{\link[=get.w]{get.w()}} method or a list thereof. The weights can be, e.g., inverse probability weights or matching weights resulting from a matching algorithm.}

\item{cluster}{either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the input object. See \code{\link{class-bal.tab.cluster}} for details.}

\item{imp}{either a vector containing imputation indices for each unit or a string containing the name of the imputation index variable in \code{data} or the input object. See \code{\link{class-bal.tab.imp}} for details. Not necessary if \code{data} is a \code{mids} object.}

\item{pairwise}{whether balance should be computed for pairs of treatments or for each treatment against all groups combined. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details. This can also be used with a binary treatment to assess balance with respect to the full sample.}

\item{s.weights}{Optional; either a vector containing sampling weights for each unit or a string containing the name of the sampling weight variable in \code{data}. These function like regular weights except that both the adjusted and unadjusted samples will be weighted according to these weights if weights are used. If \code{sampw} was supplied in the call to \code{ps()}, \code{mnps()}, \code{iptw()}, or \code{ps.cont()}, they will automatically be supplied to \code{s.weights} and do not need be specified again (though there is no harm if they are).}

\item{abs}{\code{logical}; whether displayed balance statistics should be in absolute value or not.}

\item{subset}{a \code{logical} or \code{numeric} vector denoting whether each observation should be included or which observations should be included. If \code{logical}, it should have length equal to the number of units. \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.}

\item{quick}{\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.}

\item{...}{for some input types, other arguments that are required or allowed. Otherwise, further arguments to control display of output. See \link[=display-options]{display options} for details.}
}
\value{
For binary or continuous point treatments, if clusters are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{ps} object. See \code{\link[=bal.tab]{bal.tab()}} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link{class-bal.tab.cluster}} for details.

If \code{mnps()} is used with multi-category treatments, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison and a summary of balance across pairwise comparisons. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details.
}
\description{
Generates balance statistics for \code{ps}, \code{mnps}, and \code{iptw} objects from \pkg{twang} and for \code{ps.cont} objects from \pkg{twangContinuous}.
}
\details{
\code{bal.tab.ps()} generates a list of balance summaries for the input object given, and functions similarly to \pkgfun{twang}{bal.table}. The variances used in the denominator of the standardized mean differences computed in \code{twang::bal.table()} are weighted and computed using \code{survey::svyvar()} and are unweighted here (except when \code{s.weights} are specified, in which case \code{\link[=col_w_sd]{col_w_sd()}} is used). \pkg{twang} also uses "all" as the default \code{s.d.denom} when the estimand is the ATE; the default here is "pooled". For these reasons, results may differ slightly between the two packages.
}
\examples{
\dontshow{if (requireNamespace("twang", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{library(twang); data("lalonde", package = "cobalt")

## Using ps() for generalized boosted modeling
ps.out <- ps(treat ~ age + educ + married + race +
                 nodegree + re74 + re75, data = lalonde, 
             stop.method = c("ks.mean", "es.mean"), 
             estimand = "ATT", verbose = FALSE)

bal.tab(ps.out, stop.method = "ks.mean", un = TRUE, 
        m.threshold = .1, disp.ks = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=bal.tab]{bal.tab()}} for details of calculations.
\item \code{\link{class-bal.tab.cluster}} for more information on clustered data.
\item \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for more information on multi-category treatments.
\item \code{\link{class-bal.tab.msm}} for more information on longitudinal treatments.
}
}
