% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoBoot.R
\name{cocoBoot}
\alias{cocoBoot}
\title{Bootstrap Based Model Assessment Procedure}
\usage{
cocoBoot(
  coco,
  numb.lags = 21,
  rep.Bootstrap = 1000,
  conf.alpha = 0.05,
  julia = FALSE,
  julia_seed = NULL
)
}
\arguments{
\item{coco}{An object of class coco}

\item{numb.lags}{Number of lags for which to compute autocorrelations}

\item{rep.Bootstrap}{Number of bootstrap replicates to use}

\item{conf.alpha}{Confidence level for the quantile intervals}

\item{julia}{if TRUE, the bootstrap is run with Julia.}

\item{julia_seed}{Seed for the julia implementation. Only used if julia equals TRUE.}
}
\value{
an object of class cocoBoot. It contains the bootstraped confidence intervals
of the autocorrelations and information on the model specifications.
}
\description{
Model checking procedure emphasizing reproducibility in fitted models to provide an overall evaluation of fit as proposed by Tsay (1992).
}
\details{
Computes bootstrap confidence intervals for the autocorrelations of a fitted model.
}
\examples{
lambda <- 1
alpha <- 0.4
set.seed(12345)
data <- cocoSim(order = 1, type = "Poisson", par = c(lambda, alpha), length = 100)
fit <- cocoReg(order = 1, type = "Poisson", data = data)

#assessment using bootstrap - R implementation
boot_r <- cocoBoot(fit, rep.Bootstrap=400)
}
\references{
Tsay, R. S. (1992) Model checking via parametric bootstraps in time series analysis. \emph{Applied Statistics} \bold{41}, 1--15.
}
