% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook.R
\name{codebook_component_scale}
\alias{codebook_component_scale}
\title{Codebook component for scales}
\usage{
codebook_component_scale(
  scale,
  scale_name,
  items,
  reliabilities,
  indent = "##"
)
}
\arguments{
\item{scale}{a scale with attributes set}

\item{scale_name}{the variable name of this scale}

\item{items}{a data.frame with the items constituting the scale}

\item{reliabilities}{a list with one or several results from calls to psych package functions for computing reliability}

\item{indent}{add # to this to make the headings in the components lower-level. defaults to beginning at h2}
}
\description{
Codebook component for scales
}
\examples{
# will generate figures in a temporary directory
old_base_dir <- knitr::opts_knit$get("base.dir")
knitr::opts_knit$set(base.dir = tempdir())
on.exit(knitr::opts_knit$set(base.dir = old_base_dir))
data("bfi")
bfi <- bfi[,c("BFIK_open", paste0("BFIK_open_", 1:4))]
codebook_component_scale(bfi[,1], "BFIK_open", bfi[,-1],
   reliabilities = list(BFIK_open = psych::alpha(bfi[,-1])))
}
