% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdp-class.R
\docType{class}
\name{cdp-class}
\alias{cdp-class}
\alias{print.cdp}
\alias{plot.cdp}
\alias{summary.cdp}
\alias{fitted.cdp}
\alias{residuals.cdp}
\alias{predict.cdp}
\title{Class and Methods for Multiscale Codependence Analysis (MCA)}
\format{
cdp-class objects contain:
\describe{
  \item{data}{ A list with two elements: the first being a copy of the
    response (`Y`) and the second being a copy of the explanatory variables
    (`X`). This is the variables that were given to \code{\link{MCA}}. }
  \item{emobj}{ The \link{eigenmap-class} object that was given to
    \code{\link{MCA}}. }
  \item{UpYXcb}{ A list with five elements: the first (`UpY`) is a matrix of
    the cross-products of structuring variable (`U`) and the response
    variable `Y`, the second (`UpX`) is a matrix of the cross-product of the
    structuring variable and the explanatory variables (`X`), the third (`C`)
    is a 3-dimensional array of the codependence coefficients, the fourth
    (`B`) is a 3-dimensional array of the coregression coefficients, and the
    fifth (`CM`) is a matrix of the multivariate codependence coefficients. }
  \item{test}{ Results of statistical testing as performed by
    \code{\link{test.cdp}} or \code{\link{permute.cdp}}. \code{NULL} if no
    testing was performed, such as when only \code{\link{MCA}} had been
    called. The results of statistical testing is a list containing the
    following members:
    \describe{
      \item{$permute}{ The number of randomized permutations used by
        \code{permute.cdp} for permutation testing. 0 or \code{FALSE} for
        parametric testing obtained using \code{\link{test.cdp}}. }
      \item{$significant}{ The indices of codependence coefficient describing
        statistically significant codependence between `Y` and `X`, in
        decreasing order of magnitude. }
      \item{$global}{ The testing table (a 5-column matrix) with phi
        statistics, degrees-of-freedom, and testwise and familywise
        probabilities of type I (alpha) error. It contains one line for each
        statistically significant global coefficient (if any) in addition to
        test results for the first, non-significant coefficient, on which the
        testing procedure stopped. }
      \item{$response}{ Tests of every single response variable (a
        3-dimensional array), had such tests been requested while calling the
        testing function, \code{NULL} otherwise. }
      \item{$permutations}{ Details about permutation testing not shown in
        `test$global` or `test$response`. \code{NULL} for parametric
        testing. }
    }
  }
}
}
\usage{
\method{print}{cdp}(x, ...)

\method{plot}{cdp}(x, col, col.signif = 2, main = "", ...)

\method{summary}{cdp}(object, ...)

\method{fitted}{cdp}(object, selection, components = FALSE, ...)

\method{residuals}{cdp}(object, selection, ...)

\method{predict}{cdp}(object, selection, newdata, components = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{cdp-class}} object.}

\item{...}{Further parameters to be passed to other functions or methods.}

\item{col}{A vector of color values to be used for plotting the multivariate
codependence coefficients.}

\item{col.signif}{Color of the frame used to mark the statistically
significant codependence coefficients.}

\item{main}{Text for the main title of the plot.}

\item{object}{A \code{\link{cdp-class}} object.}

\item{selection}{A numeric vector of indices or character vector variable
names to test or force-use. Mandatory if \code{object} is untested.}

\item{components}{A boolean specifying whether the components of fitted or
predicted values associated with single eigenfunctions in the map should be
returned.}

\item{newdata}{A list with elements $X, $meanY, and $target that contain the
information needed to make predictions (see details).}
}
\description{
A class and set of methods to handle the results of Multiscale Codependence
Analysis.
}
\details{
The `fitted`, `residuals`, and `predict` methods return a matrix of fitted,
residuals, or predicted values, respectively. The `fitted` and `predict`
methods return a list a list when argument `component` is \code{TRUE}. The
list contains the `fitted` or `predicted` values as a first element and an
array `components` as a second. That 3-dimensional array has one matrix for
each statistically significant codependence coefficient.

For making predictions, argument \code{newdata} may contain three elements:
`$X`, a matrix of new values of the explanatory variables, `$meanY`, a vector
of the predicted mean values of the responses, and `$target`, a matrix of
target scores for arbitrary locations within the study area. When no `$X` is
supplied, the descriptor given to \code{\link{MCA}} is recycled, while when
no `$meanY` is supplied, the mean values of the response variables given to
\code{\link{MCA}} are used.

Finally, when element `$target` is omitted from argument \code{newdata},
predictions are made at the sites were observations were done. When none of
the above is provided, or if \code{newdata} is omitted when calling the
prediction method, the behaviour of the `predict` method is identical to
that of the `fitted` method.

From version 0.7-1, \link{cdp-class} replaces the former class
\code{mca} used by \link{codep-package} because the standard package MASS
also had S3 methods for a class named \code{mca} that were overwritten by
those of \link{codep-package}.
}
\section{Functions}{
\itemize{
\item \code{print(cdp)}: Print method for cdp-class objects.

\item \code{plot(cdp)}: Plot method for cdp-class objects.

\item \code{summary(cdp)}: Summary method for cdp-class objects.

\item \code{fitted(cdp)}: Fitted method for cdp-class objects.

\item \code{residuals(cdp)}: Residuals method for cdp-class objects.

\item \code{predict(cdp)}: Predict method for cdp-class objects.

}}
\references{
Guénard, G., Legendre, P., Boisclair, D., and Bilodeau, M. 2010. Multiscale
codependence analysis: an integrated approach to analyse relationships across
scales. Ecology 91: 2952-2964

Guénard, G. Legendre, P. 2018. Bringing multivariate support to multiscale
codependence analysis: Assessing the drivers of community structure across
spatial scales. Meth. Ecol. Evol. 9: 292-304
}
\author{
\packageAuthor{codep}
Maintainer: \packageMaintainer{codep}
}
