% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefa_gcm.R
\name{coefa_gcm}
\alias{coefa_gcm}
\title{Generate co-occurrence matrices}
\usage{
coefa_gcm(x, ...)
}
\arguments{
\item{x}{A list containing multiple trimmed factor loading matrices}

\item{...}{Additional parameters which generate the co-occurrence matrices.}
}
\value{
A list containing multiple co-occurrence matrices.
}
\description{
The co-occurrence matrices are generated by this function. This function can
be used obtain the co-occurrence matrix for each primary study.
}
\details{
The meta-analysts can use this function to obtain the co-occurrence
matrix for each primary study. And the algorithm is that a trimmed factor
loading matrix multiplies its transpose in the list. As a result, the number
of the dimension of the matrix obtained in this step equates with that of
the items included in a scale. In this new matrix, the values on the
cross-cells indicate the clusters of the items. The greater the value in
the cross-cells of a co-occurrence matrix, the bigger the degree of similarity
between paired items.
}
\examples{
#Suppose that the matrices.tflm is the factor loading matrices trimmed.
#Note:This is just an example.
#The real co-occurrence matrix should be generated from actual studies.
mx1.tflm<-matrix(c(1,0,0,1,1,0),nrow=2,byrow=2)
mx2.tflm<-matrix(c(1,0,0,1),nrow=2,byrow=2)
matrices.tflm<-list(mx1.tflm,mx2.tflm)
#Generate co-occurrence matrices.
matrices.gcm<-coefa_gcm(matrices.tflm)
}
\references{
Shafer,A. B.(2005). Meta-analysis of the Brief Psychiatric Rating Scale
factor structure. Psychological Assessment, 17(3),324--335.

Shafer,A. B. (2006). Meta-analysis of the factor structures of four depression
 questionnaires: Beck, CES-D, Hamilton, and Zung. Journal of clinical
 psychology, 62(1), 123--146.
}
