% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort_methods.R, R/source_methods.R
\name{rm_step}
\alias{rm_step}
\alias{rm_step.Cohort}
\alias{rm_step.Source}
\title{Remove filtering step definition}
\usage{
rm_step(x, step_id, ...)

\method{rm_step}{Cohort}(
  x,
  step_id,
  run_flow = FALSE,
  hook = list(pre = get_hook("pre_rm_step_hook"), post = get_hook("post_rm_step_hook")),
  ...
)

\method{rm_step}{Source}(x, step_id, ...)
}
\arguments{
\item{x}{An object from which step should be removed.}

\item{step_id}{Id of the step to remove.}

\item{...}{Other parameters passed to specific S3 method.}

\item{run_flow}{If `TRUE`, data flow is run after the step is removed.}

\item{hook}{List of hooks describing methods before/after the Cohort is created.
See \link{hooks} for more details.}
}
\value{
Method dependent object (i.e. `Cohort` or `Source`) having selected step removed.
}
\description{
Remove filtering step definition
}
\seealso{
\link{managing-cohort}, \link{managing-source}
}
