% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{generate_cost_function}
\alias{generate_cost_function}
\title{Generate a sum of squares cost function for optimization}
\usage{
generate_cost_function(func)
}
\arguments{
\item{func}{A distribution function.}
}
\value{
A function.
}
\description{
This is an internal helper function that generates a sum of squares
  cost function for any given `r*` function (e.g. rnorm, rlognorm). The
  resulting function is intended to be used by an `optim` call for fitting
  quantiles to distribution parameters.
}
\examples{
generate_cost_function(stats::qlnorm)
}
\seealso{
Other distribution fitting functions: \code{\link{combine_lognorm_trunc}},
  \code{\link{combine_lognorm}},
  \code{\link{combine_norm}},
  \code{\link{fit_capabilities_geomean}},
  \code{\link{fit_capabilities}},
  \code{\link{fit_lognorm_trunc}},
  \code{\link{fit_lognorm}}, \code{\link{fit_norm_trunc}},
  \code{\link{fit_pois}},
  \code{\link{fit_scenarios_geomean}},
  \code{\link{fit_scenarios}},
  \code{\link{fit_threat_communities}},
  \code{\link{lognormal_to_normal}},
  \code{\link{normal_to_lognormal}}
}
\concept{distribution fitting functions}
