% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Create one or more quantitative scenarios objects suitable for simulation by 'evaluator'}
\usage{
prepare_data(scenario_parameters, capability_parameters, threat_parameters,
  questions)
}
\arguments{
\item{scenario_parameters}{Scenarios with final parameters defined.}

\item{capability_parameters}{Capabilities with final parameters defined.}

\item{threat_parameters}{Threat communities with final parameters defined.}

\item{questions}{A \code{\link{tidyrisk_question_set}} object.}
}
\value{
A list of one or more \code{\link{tidyrisk_scenario}} objects.
}
\description{
Given parameters for the scenarios, threat communities, capabilities, and
the question set, generate a list of \code{\link{tidyrisk_scenario}} objects that may be
fed into \code{evaluator::\link[evaluator]{run_simulation}} for Monte Carlo simulation.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
data(mc_domains, mc_capabilities, mc_scenarios, mc_sme_top_domains,
     calibration_questions, mc_threat_communities)
question_set <- tidyrisk_question_set(mc_domains, mc_scenarios, mc_capabilities,
                          calibration_questions, mc_sme_top_domains,
                          mc_threat_communities)
response_set <- tidyrisk_response_set(mc_calibration_answers,
                          mc_scenario_answers, mc_capability_answers)
sme_weightings <- generate_weights(question_set, response_set)
data(mc_scenario_parameters_fitted, mc_capability_parameters_fitted,
                          mc_threat_parameters_fitted)
scenario_parameters <- left_join(mc_scenario_parameters_fitted, sme_weightings, by = "sme") \%>\%
  combine_scenario_parameters()
capability_parameters <- left_join(mc_capability_parameters_fitted, sme_weightings, by = "sme") \%>\%
  combine_capability_parameters()
quantitative_scenarios <- prepare_data(scenario_parameters,
                                       capability_parameters,
                                       mc_threat_parameters_fitted,
                                       question_set)
}
