% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_handouts.R
\name{make_handouts}
\alias{make_handouts}
\title{Create a set of interview handouts for a SME}
\usage{
make_handouts(sme, questions, output_dir, calibration_questions = 10)
}
\arguments{
\item{sme}{Name of the SME.}

\item{questions}{\code{\link{tidyrisk_question_set}} object}

\item{output_dir}{Directory to place output.}

\item{calibration_questions}{Number of calibration questions to ask.}
}
\description{
Creates two MS Word documents. One is an \code{answers} document that contains
the answers to the calibration questions, the other (with the name of the SME)
does not contain answers and is intended to be a visual reference (and possible
take away) for the SME.
}
\examples{
\dontrun{
questions <- read_questions()
make_handouts("Sally Expert", questions, output_dir = tempdir())
}
}
