% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_predictors_type}
\alias{identify_predictors_type}
\title{Identify Predictor Types}
\usage{
identify_predictors_type(df = NULL, predictors = NULL)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}
}
\value{
character string: predictors type
}
\description{
Internal function to identify predictor types. The supported types are:
\itemize{
\item "numeric": all predictors belong to the classes "numeric" and/or "integer".
\item "categorical": all predictors belong to the classes "character" and/or "factor".
\item "mixed": predictors are of types "numeric" and "categorical".
\item "unknown": predictors of unknown type.
}
}
\examples{

identify_predictors_type(
  df = vi,
  predictors = vi_predictors
)

identify_predictors_type(
  df = vi,
  predictors = vi_predictors_numeric
)

identify_predictors_type(
  df = vi,
  predictors = vi_predictors_categorical
)

}
\seealso{
Other data_types: 
\code{\link{identify_predictors}()},
\code{\link{identify_predictors_categorical}()},
\code{\link{identify_predictors_numeric}()},
\code{\link{identify_predictors_zero_variance}()},
\code{\link{identify_response_type}()}
}
\concept{data_types}
