% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_formula.R
\name{model_formula}
\alias{model_formula}
\title{Generate Model Formulas}
\usage{
model_formula(
  df = NULL,
  response = NULL,
  predictors = NULL,
  term_f = NULL,
  term_args = NULL,
  random_effects = NULL,
  quiet = FALSE
)
}
\arguments{
\item{df}{(optional; data frame, tibble, or sf). A data frame with responses and predictors. Required if \code{predictors = NULL}. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{predictors}{(optional, character vector, output of \code{\link[=collinear]{collinear()}}): predictors to include in the formula. Required if \code{df = NULL}.}

\item{term_f}{(optional; string). Name of function to apply to each term in the formula, such as "s" for \code{\link[mgcv:s]{mgcv::s()}} or any other smoothing function, "poly" for \code{\link[stats:poly]{stats::poly()}}. Default: NULL}

\item{term_args}{(optional; string). Arguments of the function applied to each term. For example, for "poly" it can be "degree = 2, raw = TRUE". Default: NULL}

\item{random_effects}{(optional, string or character vector). Names of variables to be used as random effects. Each element is added to the final formula as \code{ +(1 | random_effect_name)}. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
list if \code{predictors} is a list or length of \code{response} is higher than one, and character vector otherwise.
}
\description{
Generate Model Formulas
}
\examples{
#using df, response, and predictors
#----------------------------------
df <- vi[1:1000, ]

#additive formulas
formulas_additive <- model_formula(
  df = df,
  response = c(
    "vi_numeric",
    "vi_categorical"
    ),
  predictors = vi_predictors_numeric[1:10]
)

formulas_additive

#using a formula in a model
#m <- stats::lm(
#  formula = formulas_additive[[1]],
#  data = df
#  )

# using output of collinear()
#----------------------------------
selection <- collinear(
  df = df,
  response = c(
    "vi_numeric",
    "vi_binomial"
  ),
  predictors = vi_predictors_numeric[1:10],
  quiet = TRUE
)

#polynomial formulas
formulas_poly <- model_formula(
  predictors = selection,
  term_f = "poly",
  term_args = "degree = 3, raw = TRUE"
)

formulas_poly

#gam formulas
formulas_gam <- model_formula(
  predictors = selection,
  term_f = "s"
)

formulas_gam

#adding a random effect
formulas_random_effect <- model_formula(
  predictors = selection,
  random_effects = "country_name"
)

formulas_random_effect
}
\seealso{
Other modelling_tools: 
\code{\link{case_weights}()},
\code{\link{performance_score_auc}()},
\code{\link{performance_score_r2}()},
\code{\link{performance_score_v}()}
}
\concept{modelling_tools}
