% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_encoding_arguments}
\alias{validate_encoding_arguments}
\title{Validates Arguments of \code{target_encoding_lab()}}
\usage{
validate_encoding_arguments(
  df = NULL,
  response = NULL,
  predictors = NULL,
  methods = c("mean", "loo", "rank"),
  smoothing = 0,
  white_noise = 0,
  seed = 0,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable in \code{df}. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{methods}{(optional; character vector or NULL). Name of the target encoding methods. If NULL, target encoding is ignored, and \code{df} is returned with no modification. Default: c("loo", "mean", "rank")}

\item{smoothing}{(optional; integer vector) Argument of the method "mean". Groups smaller than this number have their means pulled towards the mean of the response across all cases. Default: 0}

\item{white_noise}{(optional; numeric vector) Argument of the methods "mean", "rank", and "loo". Maximum white noise to add, expressed as a fraction of the range of the response variable. Range from 0 to 1. Default: \code{0}.}

\item{seed}{(optional; integer vector) Random seed to facilitate reproducibility when \code{white_noise} is not 0. If NULL, the function selects one at random, and the selected seed does not appear in the encoded variable names. Default: 0}

\item{overwrite}{(optional; logical) If \code{TRUE}, the original predictors in \code{df} are overwritten with their encoded versions, but only one encoding method, smoothing, white noise, and seed are allowed. Otherwise, encoded predictors with their descriptive names are added to \code{df}. Default: FALSE}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
list
}
\description{
Internal function to validate configuration arguments for \code{\link[=target_encoding_lab]{target_encoding_lab()}}.
}
\examples{
validate_encoding_arguments(
  df = vi,
  response = "vi_numeric",
  predictors = vi_predictors
  )
}
\seealso{
Other data_validation: 
\code{\link{validate_data_cor}()},
\code{\link{validate_data_vif}()},
\code{\link{validate_df}()},
\code{\link{validate_predictors}()},
\code{\link{validate_preference_order}()},
\code{\link{validate_response}()}
}
\concept{data_validation}
