% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_predictors}
\alias{validate_predictors}
\title{Validate Argument predictors}
\usage{
validate_predictors(
  df = NULL,
  response = NULL,
  predictors = NULL,
  quiet = FALSE
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
character vector: predictor names
}
\description{
Internal function to validate the \code{predictors} argument. Requires the argument 'df' to be validated with \code{\link[=validate_df]{validate_df()}}.

Validates the 'predictors' argument to ensure it complies with the requirements of the package functions. It performs the following actions:
\itemize{
\item Stops if 'df' is NULL.
\item Stops if 'df' is not validated.
\item If 'predictors' is NULL, uses column names of 'df' as 'predictors' in the 'df' data frame.
\item Print a message if there are names in 'predictors' not in the column names of 'df', and returns only the ones in 'df'.
\item Stop if the number of numeric columns in 'predictors' is smaller than 'min_numerics'.
\item Print a message if there are zero-variance columns in 'predictors' and returns a new 'predictors' argument without them.
\item Tags the vector with the attribute \code{validated = TRUE} to let the package functions skip the data validation.
}
}
\examples{

data(
  vi,
  vi_predictors
  )

#validating example data frame
vi <- validate_df(
  df = vi
)

#validating example predictors
vi_predictors <- validate_predictors(
  df = vi,
  predictors = vi_predictors
)

#tagged as validated
attributes(vi_predictors)$validated

}
\seealso{
Other data_validation: 
\code{\link{validate_data_cor}()},
\code{\link{validate_data_vif}()},
\code{\link{validate_df}()},
\code{\link{validate_encoding_arguments}()},
\code{\link{validate_preference_order}()},
\code{\link{validate_response}()}
}
\concept{data_validation}
