% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional.R
\name{run_proptests}
\alias{run_proptests}
\title{run proportional tests on extreme subset of snp pairs from two
coloc style datasets. Of all functions in this package, this is
the main one that should be used.}
\usage{
run_proptests(
  S1,
  S2,
  LD,
  topsnps = "auto",
  r2.thr = 0.95,
  maxtests = 10000,
  nauto = 200,
  adjust_n = FALSE
)
}
\arguments{
\item{S1}{coloc dataset 1}

\item{S2}{coloc dataset 2}

\item{LD}{LD matrix - rownames, colnames capture the snps and S1$snp[j] must
be represented}

\item{topsnps}{list of topsnps to be considered for testing or, if "auto",
will be automatically selected}

\item{r2.thr}{r2 threshold for initial tagging step - includes only one of
any set of snps in mutually high LD with r2 > r2.thr}

\item{maxtests}{maximum number of test pairs to consider. if more than
maxtests pairs available, will select a random sample.}

\item{nauto}{number of snps to use when automatically defining topsnps. only
has an effect if topsnps=="auto"}

\item{adjust_n}{TRUE if you want to adjust for variable sample size between
snps. This is only set up for case control data at the moment (ask if you
need quantitative) and requires that you supply separately the number of
cases and controls at each snp in each dataset, as vector elements of the lists
called n1 (cases) and n0 (controls)}
}
\value{
data.table containing the tests run
}
\description{
run proportional tests on extreme subset of snp pairs from two
coloc style datasets. Of all functions in this package, this is
the main one that should be used.
}
\examples{
library(colocPropTest)
library(coloc)
data(coloc_test_data)
attach(coloc_test_data)
LD=D1$LD
dimnames(LD)=list(D1$snp,D1$snp)
results=run_proptests(D1,D2,LD=LD,topsnps=D1$snp,maxtests=100)
min(results$fdr)
}
\author{
Chris Wallace
}
