% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_multiples}
\alias{map_multiples}
\title{Visualize multiple distributions in a series of maps}
\usage{
map_multiples(x, palette, ncol, lambda = 0, labels = NULL, return_df = FALSE)
}
\arguments{
\item{x}{RasterStack of distributions processed by \code{\link[=metrics_pull]{metrics_pull()}}.}

\item{palette}{data frame containing an HCL color palette generated using
\code{\link[=palette_timecycle]{palette_timecycle()}}, \code{\link[=palette_timeline]{palette_timeline()}}, or \code{\link[=palette_set]{palette_set()}}.}

\item{ncol}{integer specifying the number of columns in the grid of plots.}

\item{lambda}{number that allows visual tuning of intensity values via the
\code{\link[scales:modulus_trans]{scales::modulus_trans()}} function (see Details). Negative numbers decrease
apparent skew of intensity values. Positive numbers increase apparent skew
of intensity values.}

\item{labels}{character vector of layer labels for each plot. The default is
to not show labels.}

\item{return_df}{logical specifying whether the function should return a
ggplot2 plot object (FALSE) or a data frame containing the raster data and
associated cell colors.}
}
\value{
A ggplot2 plot object of the map. Alternatively, \code{return_df = TRUE}
will return a data frame containing the raster data in data frame format
along with the associated cell colors. The data frame columns are:
\itemize{
\item \code{x},\code{y}: coordinates of raster cell centers.
\item \code{cell_number}: integer indicating the cell number.
\item \code{layer_cell}: a unique ID for the cell within the layer in the format
\code{"layer-cell_number"}.
\item \code{intensity}: maximum cell value across layers divided by the maximum
value across all layers and cells; mapped to alpha level.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{layer_id}: the identity of the raster layer from which an intensity
value was pulled; mapped to hue.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
}
}
\description{
This function enables visualization of distributional
information in a series of small multiples by combining distribution
metrics and an HCL color palette.
}
\details{
The lambda parameter allows for visual tuning of highly skewed
distribution data. It is not uncommon for distributions to contain highly
skewed intensity values because individuals spend a vast majority of their
time within a relatively small area or because populations are relatively
dense during some seasons and relatively dispersed during others. This can
make visualizing distributions a challenge. The lambda parameter transforms
intensity values via the \code{\link[scales:modulus_trans]{scales::modulus_trans()}} function, allowing users
to adjust the relative visual weight of high and low intensity values.
}
\examples{
# load fisher data
data("fisher_ud")

# prepare data
r <- metrics_pull(fisher_ud)

# generate palette
pal <- palette_timeline(fisher_ud)

# produce maps
# set lambda to make areas that were used less intensively more conspicuous
map_multiples(r, pal, lambda = -5, labels = names(r))
}
\seealso{
Other map: 
\code{\link{map_single}()}
}
\concept{map}
