% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette_timecycle}
\alias{palette_timecycle}
\title{Make an HCL palette for visualizing a cyclical sequence of distributions}
\usage{
palette_timecycle(x, start_hue = 240, clockwise = TRUE)
}
\arguments{
\item{x}{RasterStack or integer describing the number of layers for which
colors need to be generated.}

\item{start_hue}{integer between -360 and 360 representing the starting hue
in an HCL color wheel. For further details, consult the documentation for
\link[colorspace:rainbow_hcl]{colorspace::rainbow_hcl}. The default value of 240 will start the palette
at "blue".}

\item{clockwise}{logical indicating which direction to move around color
wheel. The default \code{clockwise = TRUE} will yield a
"blue-green-yellow-pink-blue" palette when \code{start_hue = 240}, while
\code{clockwise = FALSE} will yield a "blue-pink-yellow-green-blue" palette.}
}
\value{
A data frame with three columns:
\itemize{
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
}
}
\description{
This function generates an HCL palette for visualizing
a cyclical sequence of distributions (e.g., a series of distributions
describing species occurrence in each of 52 weeks of the annual
cycle or a series of utilization distributions describing typical
space use by an individual animal in each hour of a 24-hour daily cycle).
}
\examples{
# load field sparrow data
data(fiespa_occ)

# generate hcl color palette
pal <- palette_timecycle(fiespa_occ)
head(pal)

# visualize the palette in HCL space with colorspace::hclplot
library(colorspace)
hclplot(pal[pal$specificity == 100, ]$color)
}
\seealso{
\link{palette_timeline} for linear sequences of distributions and
\link{palette_set} for unordered sets of distributions.

Other palette: 
\code{\link{palette_set}()},
\code{\link{palette_timeline}()}
}
\concept{palette}
