% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_colorplane.R
\name{guide_colorplane}
\alias{guide_colorplane}
\alias{guide_colourplane}
\title{Add Guide for Colorplane}
\usage{
guide_colorplane(title = waiver(), title.position = c("top", "bottom"),
  title.theme = NULL, title.hjust = 0.5, title.vjust = NULL,
  axis.title = waiver(), axis.title.position = c("bottom", "top"),
  axis.title.theme = NULL, axis.title.hjust = NULL,
  axis.title.vjust = NULL, axis.title.y = waiver(),
  axis.title.y.position = c("left", "right"), axis.title.y.theme = NULL,
  axis.title.y.hjust = NULL, axis.title.y.vjust = NULL, label = TRUE,
  label.position = c("bottom", "top"), label.theme = NULL,
  label.hjust = NULL, label.vjust = NULL, label.y.position = c("left",
  "right"), label.y.theme = NULL, label.y.hjust = NULL,
  label.y.vjust = NULL, planewidth = NULL, planeheight = NULL,
  nbin = 20, ticks = TRUE, default.unit = "line", order = 0, ...)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link{waiver}}), the name of the scale object or the name
specified in \code{\link{labs}} is used for the title.}

\item{title.position}{Character string indicating position for the main
title. One of "top" (default) or "bottom".}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link{element_text}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link{theme}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{axis.title, axis.title.y}{Character strings or expressions indicating
the horizontal and vertical axis titles in the guide, respectively. If
\code{NULL}, the title is not shown. By default (\link[ggplot2]{waiver}),
the name of the scale or the name of the variable mapped to the aesthetic.}

\item{axis.title.position, axis.title.y.position}{Character vectors indicating
the position(s) of axis titles. \code{axis.title.position}: "top" and/or
"bottom" (default). \code{axis.title.y.position}: "left" (default) and/or
"right".}

\item{axis.title.theme, axis.title.y.theme}{Theme objects for rendering the
axis title text. Typically an \code{\link[ggplot2]{element_text}} object.
When \code{NULL}, defaults to settings for \code{axis.title.x} and
\code{axis.title.y} in the plot theme.}

\item{axis.title.hjust, axis.title.vjust, axis.title.y.vjust, axis.title.y.hjust}{Numerics specifying the horizontal (\code{hjust}) and vertical
(\code{vjust}) justifications of the horizontal (\code{axis.title}) and
vertical (\code{axis.title.y}) axis title text.}

\item{label}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}

\item{label.position, label.y.position}{Character vectors indicating the
position(s) of axis labels. For \code{label.position}, "top" and/or
"bottom" (default). For \code{label.y.position}, "left" (default) and/or
"right".}

\item{label.theme, label.y.theme}{Theme objects for rendering axis label text.
Usually the object of \code{\link[ggplot2]{element_text}} is expected. By
default, the theme is specified by \code{axis.text.*} in the plot theme.}

\item{label.hjust, label.vjust, label.y.hjust, label.y.vjust}{Numerics
specifying the horizontal (\code{hjust}) and vertical (\code{vjust})
justifications of the horizontal (\code{label}) and vertical
(\code{label.y}) axis label text.}

\item{planewidth, planeheight}{Numeric or \code{\link[grid]{unit}} objects
specifying the width and height of the colorplane. Default values are 5
times the \code{legend.key.width/height} or \code{legend.key.size} in the
plot theme.}

\item{nbin}{Number specifying how many color pixels are generated for each
dimension of the colorplane. Higher numbers increase guide color accuracy
(especially for larger sized guides) at the expense of speed.}

\item{ticks}{A logical specifying if tick marks on colorbar should be
visible.}

\item{default.unit}{A character string indicating unit for \code{planewidth}
and \code{planeheight}.}

\item{order}{positive integer less that 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{...}{ignored.}
}
\description{
Generates a guide to explain the colors plotted via
\code{\link{scale_color_colorplane}} and \code{\link{scale_fill_colorplane}}.
}
\details{
The guide is based on \code{\link[ggplot2]{guide_colorbar}}, but extended to
be a plane of colors with ticks and labels for both variables in the scale.
All \code{*.theme} arguments accept two types of arguments: a complete theme
object (e.g. the object returned by \code{\link[ggplot2]{theme_grey}}) or an
\code{\link[ggplot2]{element_text}}. If a theme is given, the related element
will be extracted from the theme and used as-is. If an element is given, any
missing parameters will be inherited from the plot's theme before use. If not
specified, \code{*.hjust} and \code{*.vjust} parameters will draw from the
corresponding \code{*.theme} argument, the plot's theme, or a default of 0.5
(centered). One exception is \code{title.hjust} which has been given a
default value of 0.5 to override a undesirable default value in the default
ggplot theme. Specify \code{title.hjust = NULL} to restore normal inheritance
if needed.
}
\examples{
if(requireNamespace("mapproj")) {
  library(ggplot2)
  crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)
  states_map <- map_data("state")
  ggplot(crimes,
         aes(map_id = state, fill = Murder, fill2 = UrbanPop)) +
    geom_map(map = states_map) +
    scale_fill_colorplane() +
    expand_limits(x = states_map$long, y = states_map$lat) +
    coord_map() +
    guides(fill = guide_colorplane("My Title", axis.title = "Murder Rate",
    axis.title.y = "Urban Population \%", label.position = c("top", "bottom"),
    label.y.position = c("left", "right")))
 }
}
\references{
Based on \code{\link[ggplot2]{guide_colorbar}}, modified 2016.
}

