% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clstats.r
\name{clstats}
\alias{clstats}
\alias{print.clstats}
\title{Retrieve basic statistics from COLOURlovers.}
\usage{
clstats(type, fmt = "xml")
}
\arguments{
\item{type}{An API type. One of \dQuote{colors}, \dQuote{palettes},
\dQuote{patterns}, or \dQuote{lovers}.}

\item{fmt}{A format for the API response, one of \dQuote{xml} (the default)
or \dQuote{json}. This has essentially no effect on function behavior.}
}
\value{
A numeric value of class \dQuote{clstats}. This should be the same 
  regardless of the value of \code{fmt}.
}
\description{
Retrieve basic statistics from the COLOURlovers API.
}
\details{
Retrieve total numbers of colors, palettes, patterns, or lovers.
}
\examples{
\dontrun{ 
clstats('colors')
clstats('palettes')
clstats('patterns')
clstats('lovers')
}
}
\references{
\url{http://www.colourlovers.com/api/#stats}
}
\author{
Thomas J. Leeper
}
