% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cove.R
\name{get_cove}
\alias{get_cove}
\title{Create a co-occurrence vector (cove)}
\usage{
get_cove(x, ordered = TRUE, normalization = "none")
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_coma]{get_coma()}} function}

\item{ordered}{The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{normalization}{Should the output vector be normalized?
Either "none" or "pdf".
The "pdf" option normalizes a vector to sum to one.
The default is "none".}
}
\value{
A co-occurrence vector
}
\description{
Converts a co-occurrence matrix (coma) to
a co-occurrence vector (cove)
}
\examples{
library(comat)
data(raster_x, package = "comat")

com = get_coma(raster_x)
com

cov = get_cove(com)
cov

cov = get_cove(com, normalization = "pdf")
cov
}
