% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_test.R
\name{CI_test}
\alias{CI_test}
\title{Combined Interaction Test}
\usage{
CI_test(
  x,
  nsim = 10000,
  nc0 = 10000,
  opvalue = NULL,
  alpha = 0.05,
  report = TRUE,
  Elapsed_time = TRUE
)
}
\arguments{
\item{x}{numeric matrix, \eqn{a \times b} data matrix where the number of row and column is corresponding to the number of factor levels.}

\item{nsim}{a numeric value, the number of Monte Carlo samples for computing an exact Monte Carlo p-value. The default value is 10000.}

\item{nc0}{a numeric value, the number of Monte Carlo samples for computing the unbiasing constant \eqn{c_0} in \code{KKM.test}. The default value is 10000.}

\item{opvalue}{a numeric vector, other p-values (in addition to the six considered p-values) that are going to be combined.}

\item{alpha}{a numeric value, the level of the test. The default value is 0.05.}

\item{report}{logical: if \code{TRUE} the result of the test is reported at the \code{alpha} level.}

\item{Elapsed_time}{logical: if \code{TRUE} the progress will be printed in the console.}
}
\value{
An object of the class \code{combtest}, which is a list inducing following components:
\item{nsim}{The number of Monte Carlo samples that are used to estimate p-value.}
\item{Piepho_pvalue}{The p-value of Piepho's (1994) test.}
\item{Piepho_Stat}{The value of Piepho's (1994) test statistic.}
\item{Boik_pvalue}{The p-value of Boik's (1993) test.}
\item{Boik_Stat}{The value of Boik's (1993) test statistic.}
\item{Malik_pvalue}{The p-value of Malik's (2016) et al. test.}
\item{Malik_Stat}{The value of Malik's (2016) et al. test statistic.}
\item{KKM_pvalue}{The p-value of Kharrati-Kopaei and Miller's (2016) test.}
\item{KKM_Stat}{The value of Kharrati-Kopaei and Miller's (2016) test statistic.}
\item{KKSA_pvalue}{The p-value of Kharrati-Kopaei and Sadooghi-Alvandi's (2007) test.}
\item{KKSA_Stat}{The value of Kharrati-Kopaei and Sadooghi-Alvandi's (2007) test statistic.}
\item{Franck_pvalue}{The p-value of Franck's (2013) et al. test.}
\item{Franck_Stat}{The value of Franck's (2013) et al. test statistic.}
\item{Bonferroni}{The combined p-value by using the Bonferroni method.}
\item{Sidak}{The combined p-value by using the Sidak method.}
\item{Jacobi}{The combined p-value by using the Jacobi method.}
\item{GC}{The combined p-value by using the Gaussian copula.}
\item{data_name}{The name of the input dataset.}
\item{test}{The name of the test.}
\item{Level}{The level of test.}
\item{Result}{The result of the combined test at the alpha level with some descriptions on the type of significant interaction.}
}
\description{
This function reports the p-values of the tests for non-additivity developed by Boik (1993), Piepho (1994),
Kharrati-Kopaei and Sadooghi-Alvandi (2007), Franck et al. (2013), Malik et al. (2016)
and Kharrati-Kopaei and Miller (2016). In addition, it combines the p-values of these six tests (and some other available p-values) into a single p-value as a test statistic for testing interaction.
There are four combination methods:
Bonferroni, Sidak, Jacobi expansion, and Gaussian Copula. The results of these four combined tests are also reported. If there is a significant interaction, the type of interaction is also provided.
}
\details{
The data matrix is divided based on the row of the data matrix for \code{KKSA_test} and \code{Franck_test}. Note that \code{KKSA_test} is not applicable when \eqn{a} is less than four. \code{Franck_test} and \code{Piepho_test} are not applicable when \eqn{a} is less than three. This function needs \code{mvtnorm} package.
}
\examples{
data(CNV)
CI_test(CNV, nsim = 1000, Elapsed_time = FALSE)

}
\references{
Shenavari, Z., Kharrati-Kopaei, M. (2018). A Method for Testing Additivity in
 Unreplicated Two-Way Layouts Based on Combining Multiple Interaction Tests. International Statistical Review
 86(3): 469-487.
}
