context("Monge-Elkan comparator")

test_that("Monge-Elkan comparator is correct when using default settings", {
  comparator <- MongeElkan()
  x <- strsplit("The quick brown fox", "\\s+")
  y <- strsplit("The quicker browner fox", "\\s+")
  z <- strsplit("The quicker fox", "\\s+")
  expect_equal(comparator(x, y), (2+2*10/14)/4)
  expect_equal(comparator(x, z), (2+10/14+1/3)/4)
  expect_equal(comparator(z, x), (2+10/14)/3)
  x <- strsplit("University of Melbourne", "\\s+")
  y <- strsplit("Melbourne University", "\\s+")
  expect_equal(comparator(x, y), (3/19 + 2)/3)
})

test_that("Monge-Elkan comparator is correct when using a non-default inner comparator", {
  comparator <- MongeElkan(inner_comparator = BinaryComp(similarity = TRUE))
  x <- strsplit("The quick brown fox", "\\s+")
  y <- strsplit("The quicker browner fox", "\\s+")
  z <- strsplit("The quicker fox", "\\s+")
  expect_equal(comparator(x, y), 2/4)
  expect_equal(comparator(x, z), 2/4)
  expect_equal(comparator(z, x), 2/3)
  x <- strsplit("University of Melbourne", "\\s+")
  y <- strsplit("Melbourne University", "\\s+")
  expect_equal(comparator(x, y), 2/3)
})

test_that("Monge-Elkan comparator is correct when using a non-default aggregation function", {
  comparator <- MongeElkan(agg_function = hmean)
  x <- strsplit("The quick brown fox", "\\s+")
  y <- strsplit("The quicker browner fox", "\\s+")
  z <- strsplit("The quicker fox", "\\s+")
  expect_equal(comparator(x, y), 4/(2 + 2*14/10))
  expect_equal(comparator(x, z), 4/(2 + 14/10 + 3))
  expect_equal(comparator(z, x), 3/(2 + 14/10))
  x <- strsplit("University of Melbourne", "\\s+")
  y <- strsplit("Melbourne University", "\\s+")
  expect_equal(comparator(x, y), 3/(2 + 19/3))
})

test_that("Monge-Elkan comparator is correct when symmetrized", {
  comparator <- MongeElkan(symmetrize = TRUE)
  x <- strsplit("The quick brown fox", "\\s+")
  y <- strsplit("The quicker browner fox", "\\s+")
  z <- strsplit("The quicker fox", "\\s+")
  expect_equal(comparator(x, y), (2+2*10/14)/4)
  expect_equal(comparator(x, z), (2+10/14)/3)
  expect_equal(comparator(z, x), (2+10/14)/3)
})