% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-addMetrics.R
\name{modifyMetrics}
\alias{modifyMetrics}
\alias{clearMetrics}
\alias{addMetrics}
\title{Manipulate metrics in one or more \code{MCMCresult} object(s)}
\usage{
clearMetrics(results, byParameter = TRUE, byMCMC = TRUE)

addMetrics(
  results,
  metrics = c("mean", "median", "sd", "CI95_low", "CI95_upp", "ESS", "efficiency"),
  options = list()
)
}
\arguments{
\item{results}{an \code{MCMCresult} object or list of \code{MCMCresult}
objects.}

\item{byParameter}{\code{TRUE} or \code{FALSE}: whether to clear
\code{byParameter} metrics}

\item{byMCMC}{\code{TRUE} or \code{FALSE}: whether to clear \code{byMCMC} metrics}

\item{metrics}{character vector of metric names to add.  See
\code{\link{metrics}}.}

\item{options}{named list of options.  When calling a metric
function (e.g. \code{mean}), if there is a named element with that
name (e.g. "mean"), it will be passed as the second argument to
the metric function.}
}
\description{
Clear metrics or add metrics to MCMC results.
}
\details{
These functions provide ways to manipulate the collection
of metrics inside one or more \code{MCMCresult} objects.

The \code{\link{MCMCresult}} class is fairly simple.  One can also
modify contents of an \code{MCMCresult} object using class methods or
direct manipulation of contents.

Metrics are organized as "byParameter", when there is one result
for each parameter (column) of MCMC output, and "byMCMC", when
there is one result for an entire MCMC sample (across all
parameters).

\code{clearMetrics} clears all metrics by parameter, by MCMC, or both.

\code{addMetrics} populates a set of metrics.  See package vignette for
more information.
}
\seealso{
\link{combineMetrics}
}
