% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BaselearnerPSpline}
\alias{BaselearnerPSpline}
\title{Base-learner factory to do non-parametric B or P-spline regression}
\format{\code{\link{S4}} object.}
\description{
\code{BaselearnerPSpline} creates a spline base-learner factory
 object which can be registered within a base-learner list and then used
 for training.
}
\section{Usage}{

\preformatted{
BaselearnerPSpline$new(data_source, data_target, degree, n_knots, penalty,
  differences)
}
}

\section{Arguments}{

\describe{
\item{\code{data_source} [\code{Data} Object]}{
  Data object which contains the source data.
}
\item{\code{data_target} [\code{Data} Object]}{
  Data object which gets the transformed source data.
}
\item{\code{degree} [\code{integer(1)}]}{
  Degree of the spline functions to interpolate the knots.
}
\item{\code{n_knots} [\code{integer(1)}]}{
  Number of \strong{inner knots}. To prevent weird behavior on the edges
  the inner knots are expanded by \eqn{\mathrm{degree} - 1} additional knots.
}
\item{\code{penalty} [\code{numeric(1)}]}{
  Positive numeric value to specify the penalty parameter. Setting the
  penalty to 0 ordinary B-splines are used for the fitting.
}
\item{\code{differences} [\code{integer(1)}]}{
  The number of differences which are penalized. A higher value leads to
  smoother curves.
}
}
}

\section{Details}{

  The data matrix of the source data is restricted to have just one column.
  The spline bases are created for this single feature. Multidimensional
  splines are not supported at the moment.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classblearnerfactory_1_1_p_spline_blearner_factory.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{getData()}}{Get the data matrix of the target data which is used
  for modeling.}
\item{\code{transformData(X)}}{Transform a data matrix as defined within the
  factory. The argument has to be a matrix with one column.}
\item{\code{summarizeFactory()}}{Summarize the base-learner factory object.}
}
}

\examples{
# Sample data:
data.mat = cbind(1:10)
y = sin(1:10)

# Create new data object:
data.source = InMemoryData$new(data.mat, "my.data.name")
data.target = InMemoryData$new()

# Create new linear base-learner:
spline.factory = BaselearnerPSpline$new(data.source, data.target,
  degree = 3, n_knots = 4, penalty = 2, differences = 2)

# Get the transformed data:
spline.factory$getData()

# Summarize factory:
spline.factory$summarizeFactory()

# Transform data manually:
spline.factory$transformData(data.mat)

}
